/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins.client;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.speed.FieldOfViewHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player {
    public AbstractClientPlayerMixin(Level level, BlockPos pos, float rot, GameProfile profile) {
        super(level, pos, rot, profile);
    }

    @Inject(method={"getFieldOfViewModifier"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyFov(CallbackInfoReturnable<Float> cir) {
        if (FieldOfViewHelper.shouldIgnoreProximitySpeed(this)) {
            float original = ((Float)cir.getReturnValue()).floatValue();
            float fovScale = ((Double)Minecraft.m_91087_().f_91066_.m_231925_().m_231551_()).floatValue();
            if (fovScale == 0.0f) {
                return;
            }
            float correction = FieldOfViewHelper.getProximityFovCorrection(this);
            float newFov = 1.0f - fovScale + correction * (original + fovScale - 1.0f);
            cir.setReturnValue((Object)Float.valueOf(newFov));
        }
    }
}

