/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.items;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.core.PathRecord;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.OpenChartingScreenS2C;
import net.rasanovum.viaromana.network.packets.RoutedActionC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.VersionUtils;

public class ChartingMap
extends Item {
    static final ResourceLocation CHARTING = VersionUtils.getLocation("minecraft:item.book.page_turn");
    static final ResourceLocation SEVER = VersionUtils.getLocation("minecraft:entity.sheep.shear");

    public ChartingMap(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!CommonConfig.no_gui_charting) {
                if (!player.m_6047_() || !CommonConfig.enable_remote_map_access) {
                    PacketBroadcaster.S2C.sendToPlayer((Packet)new OpenChartingScreenS2C(), serverPlayer);
                    return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
                }
                PathGraph graph = PathGraph.getInstance((ServerLevel)serverPlayer.m_9236_());
                if (graph == null) {
                    return InteractionResultHolder.m_19098_((Object)itemStack);
                }
                Optional<Node> nearestNode = graph.getNearestNode(player.m_20183_(), CommonConfig.node_utility_distance * 2);
                if (!nearestNode.isPresent()) return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
                Node node = nearestNode.get();
                PathGraph.NetworkCache networkCache = graph.getNetworkCacheForNode(node);
                List<Node> destinations = graph.getCachedTeleportDestinationsFor(serverPlayer.m_20148_(), node);
                List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(networkCache);
                DestinationResponseS2C responsePacket = new DestinationResponseS2C(graph.getNodesAsDestinationInfo(destinations, node.getBlockPos()), null, node.getBlockPos(), networkInfos, networkCache.id());
                PacketBroadcaster.S2C.sendToPlayer((Packet)responsePacket, serverPlayer);
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
            }
        }
        if (!(player instanceof LocalPlayer)) return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (!CommonConfig.no_gui_charting) return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
        SoundEvent clickSound = SoundEvent.m_262824_((ResourceLocation)CHARTING);
        if (!PlayerData.isChartingPath(player)) {
            if (!player.m_6047_()) {
                PathRecord.start((ClientLevel)localPlayer.m_9236_(), localPlayer, localPlayer.m_20183_());
            } else {
                PacketBroadcaster.C2S.sendToServer((Packet)new RoutedActionC2S(RoutedActionC2S.Operation.SEVER_NEAREST_NODE));
                clickSound = SoundEvent.m_262824_((ResourceLocation)SEVER);
            }
        } else if (!player.m_6047_()) {
            PathRecord.end((ClientLevel)localPlayer.m_9236_(), localPlayer, localPlayer.m_20183_());
        } else {
            PathRecord.cancel((ClientLevel)localPlayer.m_9236_(), localPlayer, true);
        }
        player.m_5496_(clickSound, 1.0f, 1.0f);
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }
}

