/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.render.NodeRenderer;
import net.rasanovum.viaromana.client.render.RenderUtil;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class NodeConnectionRenderer {
    private static final double RENDER_DISTANCE = 16.0;
    private static final double FADE_BUFFER_DISTANCE = 4.0;
    private static final float RIBBON_FADE_FRACTION = 0.25f;
    private static final int MIN_SEGMENTS = 4;
    private static final int MAX_SEGMENTS = 24;
    private static final float COHERENCE = 0.6f;
    private static final float WANDER_AMPLITUDE = 0.5f;
    private static final float POINT_DENSITY = 0.5f;
    private static final int SUB_SEGMENTS = 4;
    private static final float VERTICAL_WANDER_SCALE = 0.4f;
    private static final ResourceLocation CONNECTION_TEXTURE = VersionUtils.getLocation("via_romana:textures/effect/connection_ribbon.png");

    private static RenderType getRenderType() {
        boolean shadersInUse = false;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object instance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            shadersInUse = (Boolean)irisApiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            shadersInUse = false;
        }
        return shadersInUse ? RenderType.m_234335_((ResourceLocation)CONNECTION_TEXTURE, (boolean)true) : RenderType.m_110460_((ResourceLocation)CONNECTION_TEXTURE, (boolean)true);
    }

    private NodeConnectionRenderer() {
    }

    public static void renderConnections(PoseStack poseStack, ClientLevel level, Player player, PathGraph graph, float animationTime, MultiBufferSource bufferSource, float globalAlpha) {
        if (graph == null || graph.nodesView().isEmpty() || globalAlpha <= 0.0f) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        double searchRadius = 20.0;
        List<Node> nearby = ClientPathData.getInstance().getNearbyNodes(BlockPos.m_274446_((Position)playerPos), searchRadius, false);
        if (nearby.isEmpty()) {
            return;
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        RibbonConfig primaryConfig = new RibbonConfig(0.2f, 0.25f, 0.4f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.m_6299_(NodeConnectionRenderer.getRenderType()));
        RibbonConfig secondaryConfig = new RibbonConfig(0.2f, 0.3f, -0.3f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.m_6299_(NodeConnectionRenderer.getRenderType()));
        RibbonConfig signConfig = new RibbonConfig(0.3f, 0.2f, 0.16f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.m_6299_(NodeConnectionRenderer.getRenderType()));
        RibbonConfig tempSignConfig = new RibbonConfig(0.3f, 0.2f, 0.16f, (float)Math.toRadians(70.0), 0.0f, 1.0f, 0.0f, bufferSource.m_6299_(NodeConnectionRenderer.getRenderType()));
        for (Node a : nearby) {
            Vec3 aCenter = Vec3.m_82512_((Vec3i)BlockPos.m_122022_((long)a.getPos()));
            if (playerPos.m_82557_(aCenter) > searchRadius * searchRadius) continue;
            LongIterator longIterator = a.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long bPacked = (Long)longIterator.next();
                if (bPacked <= a.getPos()) continue;
                graph.getNodeAt(BlockPos.m_122022_((long)bPacked)).ifPresent(b -> {
                    Vec3 bCenter = Vec3.m_82512_((Vec3i)BlockPos.m_122022_((long)b.getPos()));
                    if (playerPos.m_82557_(aCenter.m_165921_(bCenter, 0.5)) <= searchRadius * searchRadius) {
                        NodeConnectionRenderer.renderNodeConnection(pose, level, playerPos, animationTime, aCenter, bCenter, primaryConfig, secondaryConfig, globalAlpha);
                    }
                });
            }
            a.getSignPos().ifPresent(signPosPacked -> {
                Vec3 signCenter;
                BlockPos signPos = BlockPos.m_122022_((long)signPosPacked);
                if (LinkHandler.isSignBlock((LevelAccessor)level, signPos) && playerPos.m_82557_(aCenter.m_165921_(signCenter = Vec3.m_82512_((Vec3i)signPos), 0.5)) <= searchRadius * searchRadius) {
                    NodeConnectionRenderer.renderSignConnection(pose, level, playerPos, animationTime, aCenter, signCenter, signConfig, globalAlpha);
                }
            });
        }
        ClientPathData clientData = ClientPathData.getInstance();
        for (LinkHandler.LinkData tempLink : clientData.getTemporaryLinks()) {
            Vec3 signCenter;
            Vec3 nodeCenter;
            BlockPos nodePos = tempLink.nodePos();
            BlockPos signPos = tempLink.signPos();
            if (!LinkHandler.isSignBlock((LevelAccessor)level, signPos) || !(playerPos.m_82557_((nodeCenter = Vec3.m_82512_((Vec3i)nodePos)).m_165921_(signCenter = Vec3.m_82512_((Vec3i)signPos), 0.5)) <= searchRadius * searchRadius)) continue;
            NodeConnectionRenderer.renderSignConnection(pose, level, playerPos, animationTime, nodeCenter, signCenter, tempSignConfig, globalAlpha);
        }
    }

    private static void renderNodeConnection(PoseStack.Pose pose, ClientLevel level, Vec3 playerPos, float animationTime, Vec3 start, Vec3 end, RibbonConfig primary, RibbonConfig secondary, float globalAlpha) {
        Vec3 clampedStart = new Vec3(start.f_82479_, RenderUtil.findSuitableYPosition(level, BlockPos.m_274446_((Position)start), 1.2f), start.f_82481_);
        Vec3 clampedEnd = new Vec3(end.f_82479_, RenderUtil.findSuitableYPosition(level, BlockPos.m_274446_((Position)end), 1.2f), end.f_82481_);
        double midDist = playerPos.m_82554_(clampedStart.m_165921_(clampedEnd, 0.5));
        float alpha1 = NodeRenderer.calculateDistanceAlpha(midDist, primary.baseAlpha()) * globalAlpha;
        float alpha2 = NodeRenderer.calculateDistanceAlpha(midDist, secondary.baseAlpha()) * globalAlpha;
        if (alpha1 <= 0.01f && alpha2 <= 0.01f) {
            return;
        }
        PathData path = NodeConnectionRenderer.generateWanderingPath(clampedStart, clampedEnd, animationTime);
        if (alpha1 > 0.01f) {
            NodeConnectionRenderer.drawPath(pose, path, animationTime, primary, alpha1);
        }
        if (alpha2 > 0.01f) {
            NodeConnectionRenderer.drawPath(pose, path, animationTime, secondary, alpha2);
        }
    }

    private static void renderSignConnection(PoseStack.Pose pose, ClientLevel level, Vec3 playerPos, float animationTime, Vec3 start, Vec3 end, RibbonConfig config, float globalAlpha) {
        Vec3 clampedStart = start.m_193103_(Direction.Axis.Y, RenderUtil.findSuitableYPosition(level, BlockPos.m_274446_((Position)start), 1.2f));
        double midDist = playerPos.m_82554_(clampedStart.m_165921_(end, 0.5));
        float alpha = NodeRenderer.calculateDistanceAlpha(midDist, config.baseAlpha()) * globalAlpha;
        if (alpha <= 0.01f) {
            return;
        }
        PathData path = NodeConnectionRenderer.generateSimpleArcPath(clampedStart, end, animationTime);
        NodeConnectionRenderer.drawPath(pose, path, animationTime, config, alpha);
    }

    private static PathData generateWanderingPath(Vec3 start, Vec3 end, float animationTime) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        ArrayList<Vec3> tangents = new ArrayList<Vec3>();
        Vec3 diff = end.m_82546_(start);
        double dist = diff.m_82553_();
        if (dist < 0.01) {
            return new PathData(points, tangents);
        }
        float effectiveAmp = 0.19999999f;
        if (effectiveAmp <= 0.01f) {
            float baseArc = (float)(0.25 + 0.15 * Math.min(1.0, dist / 8.0));
            float pulse = (float)(Math.sin((double)animationTime * 2.0 + (start.f_82479_ + start.f_82481_) * 0.3) * 0.1);
            Vec3 mid = start.m_82549_(diff.m_82490_(0.5)).m_82520_(0.0, (double)(baseArc + pulse), 0.0);
            int segments = (int)Mth.m_14008_((double)(dist * 6.0), (double)4.0, (double)24.0);
            for (int i = 0; i <= segments; ++i) {
                float t = (float)i / (float)segments;
                points.add(NodeConnectionRenderer.quad(start, mid, end, t));
                tangents.add(NodeConnectionRenderer.quadDerivative(start, mid, end, t).m_82541_());
            }
        } else {
            List<Vec3> controlPoints = NodeConnectionRenderer.generateControlPoints(start, end, effectiveAmp);
            int numCurveSeg = controlPoints.size() - 1;
            if (numCurveSeg < 1) {
                return new PathData(points, tangents);
            }
            for (int i = 0; i < numCurveSeg; ++i) {
                Vec3 p0 = i == 0 ? controlPoints.get(0) : controlPoints.get(i - 1);
                Vec3 p1 = controlPoints.get(i);
                Vec3 p2 = controlPoints.get(i + 1);
                Vec3 p3 = i + 1 == numCurveSeg ? p2 : controlPoints.get(i + 2);
                for (int j = 0; j < 4; ++j) {
                    float t = (float)j / 4.0f;
                    points.add(NodeConnectionRenderer.catmullRom(p0, p1, p2, p3, t));
                    tangents.add(NodeConnectionRenderer.catmullRomDer(p0, p1, p2, p3, t).m_82541_());
                }
            }
            points.add(controlPoints.get(controlPoints.size() - 1));
            tangents.add((Vec3)tangents.get(tangents.size() - 1));
        }
        return new PathData(points, tangents);
    }

    private static PathData generateSimpleArcPath(Vec3 start, Vec3 end, float animationTime) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        ArrayList<Vec3> tangents = new ArrayList<Vec3>();
        Vec3 diff = end.m_82546_(start);
        double dist = diff.m_82553_();
        if (dist < 0.01) {
            return new PathData(points, tangents);
        }
        float baseArc = (float)(0.15 + 0.1 * Math.min(1.0, dist / 6.0));
        float pulse = (float)(Math.sin((double)animationTime * 3.0 + (start.f_82479_ + end.f_82481_) * 0.5) * 0.05);
        Vec3 mid = start.m_82549_(diff.m_82490_(0.5)).m_82520_(0.0, (double)(baseArc + pulse), 0.0);
        int segments = (int)Mth.m_14008_((double)(dist * 4.0), (double)4.0, (double)24.0);
        for (int i = 0; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            points.add(NodeConnectionRenderer.quad(start, mid, end, t));
            tangents.add(NodeConnectionRenderer.quadDerivative(start, mid, end, t).m_82541_());
        }
        return new PathData(points, tangents);
    }

    private static List<Vec3> generateControlPoints(Vec3 start, Vec3 end, float effectiveAmp) {
        ArrayList<Vec3> controlPoints = new ArrayList<Vec3>();
        controlPoints.add(start);
        Vec3 diff = end.m_82546_(start);
        double dist = diff.m_82553_();
        int numInter = (int)(dist * 0.5);
        Vec3 tangent = diff.m_82541_();
        Vec3 perp = tangent.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (perp.m_82556_() < 0.1) {
            perp = tangent.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_();
        }
        Random rand = new Random((long)(start.f_82479_ * 31.0 + end.f_82479_) ^ (long)(start.f_82481_ * 31.0 + end.f_82481_));
        for (int i = 1; i <= numInter; ++i) {
            float t = (float)i / (float)(numInter + 1);
            Vec3 basePos = start.m_82549_(diff.m_82490_((double)t));
            float horizOffset = (float)(rand.nextGaussian() * (double)effectiveAmp);
            float vertOffset = (float)(rand.nextGaussian() * (double)effectiveAmp * (double)0.4f);
            controlPoints.add(basePos.m_82549_(perp.m_82490_((double)horizOffset)).m_82520_(0.0, (double)vertOffset, 0.0));
        }
        controlPoints.add(end);
        return controlPoints;
    }

    private static void drawPath(PoseStack.Pose pose, PathData path, float animationTime, RibbonConfig config, float baseAlpha) {
        if (path.points().size() < 2) {
            return;
        }
        float vScroll = -(animationTime * config.scrollSpeedSec());
        double totalDist = path.points().get(0).m_82554_(path.points().get(path.points().size() - 1));
        for (int i = 0; i < path.points().size() - 1; ++i) {
            float t0 = (float)i / (float)(path.points().size() - 1);
            float t1 = (float)(i + 1) / (float)(path.points().size() - 1);
            float alpha0 = baseAlpha * NodeConnectionRenderer.fadeEnds(t0);
            float alpha1 = baseAlpha * NodeConnectionRenderer.fadeEnds(t1);
            float v0 = t0 * (float)totalDist * 0.25f + vScroll;
            float v1 = t1 * (float)totalDist * 0.25f + vScroll;
            NodeConnectionRenderer.renderCrossedQuads(pose, config.consumer(), path.points().get(i), path.points().get(i + 1), path.tangents().get(i), path.tangents().get(i + 1), v0, v1, alpha0, alpha1, config.width(), config.crossAngleRadians(), config.r(), config.g(), config.b());
        }
    }

    private static void renderCrossedQuads(PoseStack.Pose pose, VertexConsumer consumer, Vec3 p0, Vec3 p1, Vec3 tangent0, Vec3 tangent1, float v0, float v1, float alpha0, float alpha1, float width, float crossAngleRadians, float r, float g, float b) {
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 offsetDir0 = up.m_82546_(tangent0.m_82490_(up.m_82526_(tangent0))).m_82541_().m_82490_((double)width);
        Vec3 offsetDir1 = up.m_82546_(tangent1.m_82490_(up.m_82526_(tangent1))).m_82541_().m_82490_((double)width);
        Vec3 normal0 = tangent0.m_82537_(offsetDir0).m_82541_();
        NodeConnectionRenderer.addDoubleSidedQuad(pose, consumer, p0, p1, offsetDir0, offsetDir1, v0, v1, alpha0, alpha1, normal0, r, g, b);
        Vec3 rotatedOffset0 = NodeConnectionRenderer.rotateAroundAxis(offsetDir0, tangent0, crossAngleRadians);
        Vec3 rotatedOffset1 = NodeConnectionRenderer.rotateAroundAxis(offsetDir1, tangent1, crossAngleRadians);
        Vec3 rotatedNormal0 = tangent0.m_82537_(rotatedOffset0).m_82541_();
        NodeConnectionRenderer.addDoubleSidedQuad(pose, consumer, p0, p1, rotatedOffset0, rotatedOffset1, v0, v1, alpha0, alpha1, rotatedNormal0, r, g, b);
    }

    private static void addDoubleSidedQuad(PoseStack.Pose pose, VertexConsumer consumer, Vec3 p0, Vec3 p1, Vec3 n0, Vec3 n1, float v0, float v1, float alpha0, float alpha1, Vec3 frontNormal, float r, float g, float b) {
        Vec3 e1s = p0.m_82546_(n0);
        Vec3 e1e = p1.m_82546_(n1);
        Vec3 e2s = p0.m_82549_(n0);
        Vec3 e2e = p1.m_82549_(n1);
        int overlay = 0;
        int light = 0xF000F0;
        int rgb = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        int color0 = (int)(alpha0 * 255.0f) << 24 | rgb;
        int color1 = (int)(alpha1 * 255.0f) << 24 | rgb;
        NodeConnectionRenderer.put(pose, consumer, e1s, color0, 0.0f, v0, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e1e, color1, 0.0f, v1, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e2e, color1, 1.0f, v1, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e2s, color0, 1.0f, v0, overlay, light, frontNormal);
        Vec3 backNormal = frontNormal.m_82490_(-1.0);
        NodeConnectionRenderer.put(pose, consumer, e2s, color0, 0.0f, v0, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e2e, color1, 0.0f, v1, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e1e, color1, 1.0f, v1, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e1s, color0, 1.0f, v0, overlay, light, backNormal);
    }

    private static void put(PoseStack.Pose pose, VertexConsumer consumer, Vec3 pos, int color, float u, float v, int overlay, int light, Vec3 normal) {
        Matrix4f matrix = pose.m_252922_();
        consumer.m_252986_(matrix, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_193479_(color).m_7421_(u, v).m_86008_(0).m_85969_(0xF000F0).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private static Vec3 rotateAroundAxis(Vec3 v, Vec3 axis, float angle) {
        float cos = Mth.m_14089_((float)angle);
        float sin = Mth.m_14031_((float)angle);
        float dot = (float)v.m_82526_(axis);
        return v.m_82490_((double)cos).m_82549_(axis.m_82537_(v).m_82490_((double)sin)).m_82549_(axis.m_82490_((double)(dot * (1.0f - cos))));
    }

    private static float fadeEnds(float t) {
        return Mth.m_14036_((float)(Math.min(t, 1.0f - t) / 0.25f), (float)0.0f, (float)1.0f);
    }

    private static Vec3 quad(Vec3 p0, Vec3 p1, Vec3 p2, float t) {
        float it = 1.0f - t;
        return new Vec3((double)(it * it) * p0.f_82479_ + (double)(2.0f * it * t) * p1.f_82479_ + (double)(t * t) * p2.f_82479_, (double)(it * it) * p0.f_82480_ + (double)(2.0f * it * t) * p1.f_82480_ + (double)(t * t) * p2.f_82480_, (double)(it * it) * p0.f_82481_ + (double)(2.0f * it * t) * p1.f_82481_ + (double)(t * t) * p2.f_82481_);
    }

    private static Vec3 quadDerivative(Vec3 p0, Vec3 p1, Vec3 p2, float t) {
        return new Vec3((double)(2.0f * (1.0f - t)) * (p1.f_82479_ - p0.f_82479_) + (double)(2.0f * t) * (p2.f_82479_ - p1.f_82479_), (double)(2.0f * (1.0f - t)) * (p1.f_82480_ - p0.f_82480_) + (double)(2.0f * t) * (p2.f_82480_ - p1.f_82480_), (double)(2.0f * (1.0f - t)) * (p1.f_82481_ - p0.f_82481_) + (double)(2.0f * t) * (p2.f_82481_ - p1.f_82481_));
    }

    private static Vec3 catmullRom(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return p0.m_82490_((double)(-t3 + 2.0f * t2 - t)).m_82549_(p1.m_82490_((double)(3.0f * t3 - 5.0f * t2 + 2.0f))).m_82549_(p2.m_82490_((double)(-3.0f * t3 + 4.0f * t2 + t))).m_82549_(p3.m_82490_((double)(t3 - t2))).m_82490_(0.5);
    }

    private static Vec3 catmullRomDer(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, float t) {
        float t2 = t * t;
        return p0.m_82490_((double)(-3.0f * t2 + 4.0f * t - 1.0f)).m_82549_(p1.m_82490_((double)(9.0f * t2 - 10.0f * t))).m_82549_(p2.m_82490_((double)(-9.0f * t2 + 8.0f * t + 1.0f))).m_82549_(p3.m_82490_((double)(3.0f * t2 - 2.0f * t))).m_82490_(0.5);
    }

    private record RibbonConfig(float baseAlpha, float width, float scrollSpeedSec, float crossAngleRadians, float r, float g, float b, VertexConsumer consumer) {
    }

    private record PathData(List<Vec3> points, List<Vec3> tangents) {
    }
}

