/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.FadeManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.LinkedSignToast;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class LinkIndicationHandler {
    private static int tickCounter = 0;
    private static final int SCAN_INTERVAL = 10;
    private static final double RENDER_RADIUS = 12.0;
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final List<BlockPos> CACHED_SIGNS = new ArrayList<BlockPos>();
    private static final Component TOOLTIP_TEXT = Component.m_237115_((String)"gui.viaromana.left_click_hover_tip");
    private static final ResourceLocation CURSOR = VersionUtils.getLocation("via_romana:textures/screens/cursor.png");
    private static final int ICON_SIZE = 18;
    private static float currentOpacity = 0.0f;
    private static final float fadeSpeed = 0.25f;
    private static boolean isHovering = false;
    static final double driftRange = 0.5;

    public static void onClientTick() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null || client.f_91074_ == null || client.m_91104_()) {
            return;
        }
        if (CommonConfig.enable_custom_cursor) {
            LinkIndicationHandler.handleLookTarget(client);
            LinkIndicationHandler.updateOpacity();
            if (isHovering && client.f_91074_ != null && !PlayerData.hasSeenLinkedSignToast((Player)client.f_91074_)) {
                client.m_91300_().m_94922_((Toast)new LinkedSignToast((Component)Component.m_237115_((String)"toast.viaromana.linked_sign_hint.title"), (Component)Component.m_237115_((String)"toast.viaromana.linked_sign_hint.description")));
                PlayerData.setSeenLinkedSignToast((Player)client.f_91074_, true);
            }
        } else {
            currentOpacity = 0.0f;
            isHovering = false;
        }
        if (++tickCounter % 10 != 0) {
            return;
        }
        LinkIndicationHandler.updateCacheAndSpawnParticles(client);
    }

    public static float getCrosshairAlpha() {
        if (!CommonConfig.enable_custom_cursor) {
            return 1.0f;
        }
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        return (1.0f - currentOpacity) * globalFade;
    }

    public static void render(GuiGraphics graphics, float tickDelta) {
        if (currentOpacity <= 0.05f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        float alpha = Mth.m_14036_((float)currentOpacity, (float)0.0f, (float)1.0f);
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        if ((alpha *= globalFade) <= 0.01f) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        graphics.m_280163_(CURSOR, (width - 18) / 2, (height - 18) / 2, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void updateOpacity() {
        if (isHovering) {
            if ((currentOpacity += 0.25f) > 1.0f) {
                currentOpacity = 1.0f;
            }
        } else if ((currentOpacity -= 0.25f) < 0.0f) {
            currentOpacity = 0.0f;
        }
    }

    private static void handleLookTarget(Minecraft mc) {
        BlockPos hitPos;
        isHovering = false;
        if (Objects.requireNonNull(mc.f_91074_).m_6047_()) {
            return;
        }
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && CACHED_SIGNS.contains(hitPos = ((BlockHitResult)mc.f_91077_).m_82425_())) {
            isHovering = true;
        }
    }

    private static void updateCacheAndSpawnParticles(Minecraft client) {
        CACHED_SIGNS.clear();
        assert (client.f_91074_ != null);
        BlockPos playerPos = client.f_91074_.m_20183_();
        List<Node> nearbyNodes = ClientPathData.getInstance().getNearbyNodes(playerPos, 12.0, false);
        for (Node node : nearbyNodes) {
            if (!node.isLinked()) continue;
            node.getSignPos().ifPresent(signPosLong -> {
                BlockPos signPos = BlockPos.m_122022_((long)signPosLong);
                if (signPos.m_123331_((Vec3i)playerPos) <= 144.0) {
                    CACHED_SIGNS.add(signPos);
                    LinkIndicationHandler.spawnLinkParticles((Level)client.f_91073_, signPos);
                }
            });
        }
    }

    private static void spawnLinkParticles(Level level, BlockPos pos) {
        if (!CommonConfig.enable_sign_particles) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            double startX = (double)pos.m_123341_() + 0.5 + (RANDOM.m_188500_() - 0.5) * 1.5;
            double startY = (double)pos.m_123342_() + 0.5 + RANDOM.m_188500_() * 0.8;
            double startZ = (double)pos.m_123343_() + 0.5 + (RANDOM.m_188500_() - 0.5) * 1.5;
            double endX = startX + (RANDOM.m_188500_() - 0.5) * 0.5;
            double endZ = startZ + (RANDOM.m_188500_() - 0.5) * 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, endX, startY, endZ, startX - endX, 0.0, startZ - endZ);
        }
    }
}

