/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.gui.ChartingScreen;
import net.rasanovum.viaromana.client.gui.LinkSignScreen;
import net.rasanovum.viaromana.client.gui.TeleportMapScreen;
import net.rasanovum.viaromana.client.gui.WarpBlockScreen;
import net.rasanovum.viaromana.util.VersionUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ClientCursorHandler {
    private static long customCursorHandle = 0L;
    private static boolean isCustomCursorActive = false;
    private static boolean hasInitialized = false;
    private static final double CURSOR_SCALE = 2.0;
    private static final ResourceLocation CURSOR = VersionUtils.getLocation("via_romana:textures/screens/cursor.png");

    private static void loadCursor(Minecraft mc) {
        block23: {
            if (customCursorHandle != 0L || hasInitialized) {
                return;
            }
            hasInitialized = true;
            try {
                Optional resource = mc.m_91098_().m_213713_(CURSOR);
                if (!resource.isPresent()) break block23;
                try (InputStream stream = ((Resource)resource.get()).m_215507_();
                     NativeImage image = NativeImage.m_85058_((InputStream)stream);
                     MemoryStack stack = MemoryStack.stackPush();){
                    int newWidth = (int)((double)image.m_84982_() * 2.0);
                    int newHeight = (int)((double)image.m_85084_() * 2.0);
                    ByteBuffer textureBuffer = MemoryUtil.memAlloc((int)(newWidth * newHeight * 4));
                    for (int y = 0; y < newHeight; ++y) {
                        for (int x = 0; x < newWidth; ++x) {
                            int srcX = Math.min((int)((double)x / 2.0), image.m_84982_() - 1);
                            int srcY = Math.min((int)((double)y / 2.0), image.m_85084_() - 1);
                            textureBuffer.putInt(image.m_84985_(srcX, srcY));
                        }
                    }
                    textureBuffer.flip();
                    GLFWImage cursorImage = GLFWImage.malloc((MemoryStack)stack);
                    cursorImage.width(newWidth);
                    cursorImage.height(newHeight);
                    cursorImage.pixels(textureBuffer);
                    customCursorHandle = GLFW.glfwCreateCursor((GLFWImage)cursorImage, (int)0, (int)0);
                    MemoryUtil.memFree((Buffer)textureBuffer);
                }
            }
            catch (IOException e) {
                ViaRomana.LOGGER.warn("Custom Cursor allocation failed: {}", (Object)e.getMessage());
            }
        }
    }

    public static void onClientTick() {
        boolean shouldBeCustom;
        Minecraft mc = Minecraft.m_91087_();
        if (!hasInitialized) {
            ClientCursorHandler.loadCursor(mc);
            if (customCursorHandle == 0L) {
                return;
            }
        }
        long windowHandle = mc.m_91268_().m_85439_();
        boolean bl = shouldBeCustom = CommonConfig.enable_custom_cursor && (mc.f_91080_ instanceof TeleportMapScreen || mc.f_91080_ instanceof LinkSignScreen || mc.f_91080_ instanceof ChartingScreen || mc.f_91080_ instanceof WarpBlockScreen);
        if (shouldBeCustom && !isCustomCursorActive) {
            GLFW.glfwSetCursor((long)windowHandle, (long)customCursorHandle);
            isCustomCursorActive = true;
        } else if (!shouldBeCustom && isCustomCursorActive) {
            GLFW.glfwSetCursor((long)windowHandle, (long)0L);
            isCustomCursorActive = false;
        }
    }

    public static void destroy() {
        if (customCursorHandle != 0L) {
            GLFW.glfwDestroyCursor((long)customCursorHandle);
            customCursorHandle = 0L;
        }
    }
}

