/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.rasanovum.viaromana.client.gui.elements.MapIconButton;
import net.rasanovum.viaromana.path.Node;

public class MapIconButtonGroup {
    private final List<MapIconButton> buttons = new ArrayList<MapIconButton>();
    private MapIconButton selectedButton = null;
    private final Consumer<Node.Icon> onSelectionChange;

    public MapIconButtonGroup(Consumer<Node.Icon> onSelectionChange) {
        this.onSelectionChange = onSelectionChange;
    }

    public List<MapIconButton> createIconButtons(Font font, int startX, int startY, int columns, int spacing) {
        Node.Icon[] icons = Node.Icon.values();
        for (int i = 0; i < icons.length; ++i) {
            int row = i / columns;
            int col = i % columns;
            int x = startX + col * (32 + spacing);
            int y = startY + row * (32 + spacing);
            MapIconButton button = new MapIconButton(font, x, y, icons[i], this::selectByIcon);
            this.buttons.add(button);
        }
        return new ArrayList<MapIconButton>(this.buttons);
    }

    public void addButton(MapIconButton button) {
        this.buttons.add(button);
    }

    public void selectButton(MapIconButton button) {
        if (!this.buttons.contains((Object)button)) {
            return;
        }
        for (MapIconButton btn : this.buttons) {
            btn.setSelected(false);
        }
        button.setSelected(true);
        this.selectedButton = button;
        if (this.onSelectionChange != null) {
            this.onSelectionChange.accept(button.getIcon());
        }
    }

    public void selectByIcon(Node.Icon icon) {
        for (MapIconButton button : this.buttons) {
            if (button.getIcon() != icon) continue;
            this.selectButton(button);
            break;
        }
    }

    public Node.Icon getSelectedIcon() {
        return this.selectedButton != null ? this.selectedButton.getIcon() : null;
    }

    public MapIconButton getSelectedButton() {
        return this.selectedButton;
    }
}

