/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.rasanovum.viaromana.util.VersionUtils;

public class MapCycleButton<T>
extends AbstractButton {
    private final List<T> values;
    private final Consumer<T> onValueChange;
    private final Function<T, Component> displayFunction;
    private final Font font;
    private final Component tooltip;
    private int selectedIndex = 0;
    private boolean isSelected = false;
    private Runnable customOnPress = null;

    public MapCycleButton(Font font, int x, int y, int width, int height, List<T> values, T initialValue, Function<T, Component> displayFunction, Consumer<T> onValueChange) {
        this(font, x, y, width, height, values, initialValue, displayFunction, onValueChange, null);
    }

    public MapCycleButton(Font font, int x, int y, int width, int height, List<T> values, T initialValue, Function<T, Component> displayFunction, Consumer<T> onValueChange, Component tooltip) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.font = font;
        this.values = values;
        this.displayFunction = displayFunction;
        this.onValueChange = onValueChange;
        this.tooltip = tooltip;
        if (this.tooltip != null && !this.tooltip.getString().isEmpty()) {
            this.m_257544_(Tooltip.m_257550_((Component)tooltip));
        }
        for (int i = 0; i < values.size(); ++i) {
            if (!values.get(i).equals(initialValue)) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void m_5691_() {
        if (this.customOnPress != null) {
            this.customOnPress.run();
        } else {
            this.selectedIndex = (this.selectedIndex + 1) % this.values.size();
            T newValue = this.values.get(this.selectedIndex);
            if (this.onValueChange != null) {
                this.onValueChange.accept(newValue);
            }
        }
    }

    public void setOnPress(Runnable onPress) {
        this.customOnPress = onPress;
    }

    public T getValue() {
        return this.values.get(this.selectedIndex);
    }

    public void setValue(T value) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).equals(value)) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        int currentTextColor = 4139547;
        int checkboxSize = 8;
        int checkboxX = this.m_252754_() + 6;
        int checkboxY = this.m_252907_() - 1 + (this.f_93619_ - checkboxSize) / 2;
        guiGraphics.m_280509_(checkboxX, checkboxY, checkboxX + checkboxSize, checkboxY + 1, -12637669);
        guiGraphics.m_280509_(checkboxX, checkboxY + checkboxSize - 1, checkboxX + checkboxSize, checkboxY + checkboxSize, -12637669);
        guiGraphics.m_280509_(checkboxX, checkboxY, checkboxX + 1, checkboxY + checkboxSize, -12637669);
        guiGraphics.m_280509_(checkboxX + checkboxSize - 1, checkboxY, checkboxX + checkboxSize, checkboxY + checkboxSize, -12637669);
        if (this.isSelected || this.m_274382_()) {
            int iconSize = 16;
            int iconX = checkboxX - 3;
            int iconY = checkboxY - 6;
            if (this.isSelected) {
                guiGraphics.m_280163_(VersionUtils.getLocation("via_romana:textures/screens/element_check.png"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            } else {
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                guiGraphics.m_280163_(VersionUtils.getLocation("via_romana:textures/screens/element_check.png"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            }
        }
        Component displayText = this.displayFunction.apply(this.getValue());
        String text = displayText.getString();
        int textX = checkboxX + checkboxSize + 6;
        int n = this.m_252907_();
        Objects.requireNonNull(this.font);
        int textY = n + (this.f_93619_ - 9) / 2;
        guiGraphics.m_280056_(this.font, text, textX, textY, currentTextColor, false);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }
}

