/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.FadeManager;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.SignValidationRequestC2S;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.teleport.TeleportHelper;
import net.rasanovum.viaromana.util.EffectUtils;
import net.rasanovum.viaromana.util.VersionUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class TeleportMapScreen
extends Screen {
    private MapClient.MapTexture mapTexture;
    private MapRenderer mapRenderer;
    private final List<DestinationResponseS2C.NodeNetworkInfo> networkNodes;
    private final BlockPos signPos;
    private final BlockPos sourceNodePos;
    private final UUID networkId;
    private final List<TeleportHelper.TeleportDestination> destinations;
    private final Map<BlockPos, DestinationResponseS2C.NodeNetworkInfo> networkNodeMap;
    private BlockPos minBounds;
    private BlockPos maxBounds;
    private float animationProgress = 0.0f;
    private long animationStartMillis = -1L;
    private long totalAnimationDurationMillis = 500L;
    private int totalAnimationWaves = 1;
    private int completedAnimationWaves = 0;
    private final Set<BlockPos> animatedNodes = new HashSet<BlockPos>();
    private final List<DestinationResponseS2C.NodeNetworkInfo> nodesToAnimate = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>();
    private final Map<BlockPos, Float> destinationFadeProgress = new HashMap<BlockPos, Float>();
    private final Set<BlockPos> validatedNodes = new HashSet<BlockPos>();
    private final Set<BlockPos> destinationPositions;
    private static final float SCREEN_FADE_IN_SPEED = 0.05f;
    private float screenAlpha = 0.0f;
    private static final int MARKER_SIZE = 16;
    private static final int PLAYER_MARKER_SIZE = 8;
    private static final float MARKER_FADE_SPEED = 0.05f;
    private static final int DIRECTION_INDICATOR_BUFFER = 2;
    private static final float DIRECTION_ANGLE_RANGE = 45.0f;
    private static final float DIRECTION_BASE_OPACITY = 1.0f;
    private static final float DIRECTION_FADE_CURVE = 1.0f;
    private static final int DIRECTION_COLOR_RGB = 0xFFFFFF;
    private static int LINE_COLOR_BASE = 0xFFFFFF;
    private static int LINE_COLOR_UNDERGROUND = 0xFFFFFF;
    private static float LINE_OPACITY = 1.0f;

    public TeleportMapScreen(DestinationResponseS2C packet) {
        super((Component)Component.m_237113_((String)"Teleport Network"));
        this.signPos = packet.signPos();
        this.sourceNodePos = packet.sourceNodePos();
        this.networkId = packet.networkId();
        this.networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(packet.networkNodes());
        this.destinations = packet.destinations().stream().map(dest -> new TeleportHelper.TeleportDestination(dest.position, dest.name, dest.distance, dest.icon)).collect(Collectors.toList());
        this.networkNodeMap = packet.networkNodes().stream().collect(Collectors.toMap(info -> info.position, info -> info));
        this.destinationPositions = this.destinations.stream().map(dest -> dest.position).collect(Collectors.toSet());
        this.configureAnimationTiming();
        this.calculateBounds();
        this.mapRenderer = new MapRenderer(this.minBounds, this.maxBounds);
        this.requestMapAsync(this.minBounds, this.maxBounds);
    }

    private void requestMapAsync(BlockPos paddedMin, BlockPos paddedMax) {
        ((CompletableFuture)MapClient.requestMap(this.networkId, paddedMin, paddedMax, this.networkNodes).thenAccept(mapInfo -> {
            if (mapInfo != null) {
                assert (this.f_96541_ != null);
                this.f_96541_.execute(() -> {
                    if (this.mapTexture != null) {
                        this.mapTexture.close();
                    }
                    this.mapTexture = MapClient.createTexture(mapInfo);
                    if (this.mapRenderer != null) {
                        this.mapRenderer.setMapTexture(this.mapTexture);
                        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                    }
                });
            }
        })).exceptionally(ex -> {
            ViaRomana.LOGGER.error("Failed to load map for network {}", (Object)this.networkId, ex);
            return null;
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.sourceNodePos != null) {
            Optional.ofNullable(this.networkNodeMap.get(this.sourceNodePos)).ifPresent(this.nodesToAnimate::add);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.mapTexture == null || this.f_96541_ == null || this.f_96541_.f_91074_ == null || this.mapRenderer == null) {
            return;
        }
        if (this.screenAlpha < 1.0f) {
            this.screenAlpha = Math.min(1.0f, this.screenAlpha + 0.05f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.screenAlpha);
        this.mapRenderer.render(guiGraphics, this.f_96543_, this.f_96544_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderNetwork(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        Set<BlockPos> revealedNodes = this.getRevealedNodes();
        TeleportHelper.TeleportDestination hoveredDestination = this.findDestinationAtPosition(revealedNodes, mouseX, mouseY);
        this.renderDestinationMarkers(guiGraphics, revealedNodes, hoveredDestination);
        this.renderPlayerMarker(guiGraphics, (Player)this.f_96541_.f_91074_);
        this.renderTooltip(guiGraphics, hoveredDestination, mouseX, mouseY);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private int applyGlobalFade(int color) {
        if (this.screenAlpha >= 1.0f) {
            return color;
        }
        int alpha = color >> 24 & 0xFF;
        int newAlpha = (int)((float)alpha * this.screenAlpha);
        return newAlpha << 24 | color & 0xFFFFFF;
    }

    private int applyLineAlpha(int color) {
        if (LINE_OPACITY >= 1.0f) {
            return color;
        }
        int alpha = color >> 24 & 0xFF;
        int newAlpha = (int)((float)alpha * LINE_OPACITY);
        return newAlpha << 24 | color & 0xFFFFFF;
    }

    private void renderNetwork(GuiGraphics guiGraphics) {
        double dist;
        if (this.networkNodeMap.isEmpty() || this.mapRenderer == null) {
            return;
        }
        float scale = 1.0f;
        Point p1 = this.mapRenderer.worldToScreen(this.minBounds, this.f_96543_, this.f_96544_);
        Point p2 = this.mapRenderer.worldToScreen(this.minBounds.m_7918_(1, 0, 0), this.f_96543_, this.f_96544_);
        if (p1 != null && p2 != null && (dist = Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0))) > 0.001) {
            scale = (float)dist;
        }
        float drawSize = Math.max(1.0f, scale);
        LINE_COLOR_BASE = Color.decode(CommonConfig.line_colors.get(0)).getRGB();
        LINE_COLOR_UNDERGROUND = Color.decode(CommonConfig.line_colors.get(1)).getRGB();
        LINE_OPACITY = CommonConfig.line_opacity;
        this.updateAnimationProgress();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f renderMatrix = new Matrix4f((Matrix4fc)matrix);
        renderMatrix.translate(0.0f, 0.0f, 5.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)513);
        RenderSystem.depthMask((boolean)true);
        HashSet<BlockPos> dynamicNodeSet = new HashSet<BlockPos>();
        for (DestinationResponseS2C.NodeNetworkInfo n : this.nodesToAnimate) {
            dynamicNodeSet.add(n.position);
        }
        for (DestinationResponseS2C.NodeNetworkInfo nodeInfo : this.networkNodes) {
            Optional<Point> startScreenPosOpt;
            BlockPos startPos = nodeInfo.position;
            boolean isStatic = this.animatedNodes.contains(startPos);
            boolean isDynamic = dynamicNodeSet.contains(startPos);
            if (!isStatic && !isDynamic || (startScreenPosOpt = this.worldToScreen(startPos)).isEmpty()) continue;
            Point startScreenPos = startScreenPosOpt.get();
            for (BlockPos endPos : nodeInfo.connections) {
                boolean isEndStatic = this.animatedNodes.contains(endPos);
                boolean isEndDynamic = dynamicNodeSet.contains(endPos);
                float progress = -1.0f;
                if (isStatic && (isEndStatic || isEndDynamic)) {
                    progress = 1.0f;
                } else if (isDynamic && !isEndStatic) {
                    progress = this.animationProgress;
                }
                if (!(progress >= 0.0f)) continue;
                this.drawConnection(buffer, renderMatrix, startScreenPos, endPos, nodeInfo, progress, scale, drawSize);
            }
        }
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private void drawConnection(BufferBuilder buffer, Matrix4f matrix, Point startScreenPos, BlockPos endPos, DestinationResponseS2C.NodeNetworkInfo startInfo, float progress, float scale, float drawSize) {
        DestinationResponseS2C.NodeNetworkInfo endInfo = this.networkNodeMap.get(endPos);
        boolean bothUnderground = startInfo.clearance > 0.0f && startInfo.clearance < 24.0f && endInfo != null && endInfo.clearance > 0.0f && endInfo.clearance < 24.0f;
        int color = bothUnderground ? LINE_COLOR_UNDERGROUND : LINE_COLOR_BASE;
        color = this.applyLineAlpha(color);
        Optional<Point> endScreenPosOpt = this.worldToScreen(endPos);
        if (endScreenPosOpt.isEmpty()) {
            return;
        }
        Point targetScreenPos = endScreenPosOpt.get();
        if (progress < 1.0f) {
            Point animatedEndPoint = this.getAnimatedPoint(startScreenPos, targetScreenPos, progress);
            this.drawPixelLine(buffer, matrix, startScreenPos, animatedEndPoint, scale, drawSize, color);
        } else {
            this.drawPixelLine(buffer, matrix, startScreenPos, targetScreenPos, scale, drawSize, color);
        }
    }

    private void drawPixelLine(BufferBuilder buffer, Matrix4f matrix, Point p1, Point p2, float scale, float drawSize, int color) {
        int x0 = (int)((float)p1.x / scale);
        int y0 = (int)((float)p1.y / scale);
        int x1 = (int)((float)p2.x / scale);
        int y1 = (int)((float)p2.y / scale);
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            float drawX = (float)x0 * scale;
            float drawY = (float)y0 * scale;
            this.addPixelQuad(buffer, matrix, drawX, drawY, drawSize, color);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    private void addPixelQuad(BufferBuilder buffer, Matrix4f matrix, float x, float y, float size, int color) {
        this.addVertex((VertexConsumer)buffer, matrix, x, y, color);
        this.addVertex((VertexConsumer)buffer, matrix, x, y + size, color);
        this.addVertex((VertexConsumer)buffer, matrix, x + size, y + size, color);
        this.addVertex((VertexConsumer)buffer, matrix, x + size, y, color);
    }

    private void addVertex(VertexConsumer buffer, Matrix4f matrix, float x, float y, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Vector4f vec = new Vector4f(x, y, 0.0f, 1.0f);
        matrix.transform(vec);
        buffer.m_5483_((double)vec.x, (double)vec.y, (double)vec.z).m_6122_(r, g, b, a).m_5752_();
    }

    private void updateAnimationProgress() {
        if (this.nodesToAnimate.isEmpty()) {
            return;
        }
        long now = Util.m_137550_();
        if (this.animationStartMillis < 0L) {
            this.animationStartMillis = now;
        }
        float normalizedProgress = this.totalAnimationDurationMillis <= 0L ? 1.0f : (float)(now - this.animationStartMillis) / (float)this.totalAnimationDurationMillis;
        normalizedProgress = Math.max(0.0f, Math.min(1.0f, normalizedProgress));
        float globalWaveProgress = normalizedProgress * (float)this.totalAnimationWaves;
        int targetCompletedWaves = Math.min(this.totalAnimationWaves, (int)Math.floor(globalWaveProgress));
        while (this.completedAnimationWaves < targetCompletedWaves && !this.nodesToAnimate.isEmpty()) {
            this.advanceAnimationWave();
        }
        if (this.nodesToAnimate.isEmpty()) {
            this.animationProgress = 1.0f;
            return;
        }
        this.animationProgress = Math.max(0.0f, Math.min(1.0f, globalWaveProgress - (float)this.completedAnimationWaves));
    }

    private void advanceAnimationWave() {
        if (this.nodesToAnimate.isEmpty()) {
            return;
        }
        HashSet<BlockPos> nextWavePositions = new HashSet<BlockPos>();
        for (DestinationResponseS2C.NodeNetworkInfo completedNode : this.nodesToAnimate) {
            this.animatedNodes.add(completedNode.position);
            if (this.destinationPositions.contains(completedNode.position)) {
                this.validateNodeSign(completedNode.position);
            }
            for (BlockPos connPos : completedNode.connections) {
                if (this.animatedNodes.contains(connPos)) continue;
                nextWavePositions.add(connPos);
            }
        }
        this.nodesToAnimate.clear();
        nextWavePositions.stream().map(this.networkNodeMap::get).filter(Objects::nonNull).forEach(this.nodesToAnimate::add);
        ++this.completedAnimationWaves;
        if (this.nodesToAnimate.isEmpty()) {
            this.animationProgress = 1.0f;
        }
    }

    private Point getAnimatedPoint(Point start, Point end, float progress) {
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        return new Point((int)((float)start.x + dx * progress), (int)((float)start.y + dy * progress));
    }

    private void renderDestinationMarkers(GuiGraphics guiGraphics, Set<BlockPos> revealedNodes, TeleportHelper.TeleportDestination hoveredDestination) {
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            boolean isValidated = this.validatedNodes.contains(dest.position) || this.sourceNodePos == null;
            boolean isRevealed = revealedNodes.contains(dest.position);
            if (isRevealed && isValidated) {
                this.destinationFadeProgress.merge(dest.position, Float.valueOf(0.05f), (a, b) -> Float.valueOf(Math.min(1.0f, a.floatValue() + b.floatValue())));
            }
            if (!this.destinationFadeProgress.containsKey(dest.position) || !isValidated) continue;
            this.worldToScreen(dest.position).ifPresent(screenPos -> {
                float alpha = this.destinationFadeProgress.get(dest.position).floatValue() * this.screenAlpha;
                boolean isHovered = hoveredDestination != null && hoveredDestination.position.equals((Object)dest.position);
                ResourceLocation markerTexture = VersionUtils.getLocation("via_romana:textures/screens/marker_" + dest.icon.toString().toLowerCase() + ".png");
                int x = screenPos.x - 8;
                int y = screenPos.y - 8;
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(alpha / 2.0f));
                guiGraphics.m_280163_(markerTexture, x + 1, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                float brightness = isHovered ? 1.25f : 1.0f;
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                guiGraphics.m_280163_(markerTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            });
        }
    }

    private void renderPlayerMarker(GuiGraphics guiGraphics, Player player) {
        if (player == null || this.f_96541_ == null) {
            return;
        }
        this.worldToScreen(player.m_20183_()).ifPresent(screenPos -> {
            int x = screenPos.x - 4;
            int y = screenPos.y - 4;
            ResourceLocation skin = this.f_96541_.m_91109_().m_240306_(player.m_36316_());
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.5f * this.screenAlpha));
            guiGraphics.m_280163_(skin, x + 1, y + 1, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.screenAlpha);
            guiGraphics.m_280163_(skin, x, y, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280163_(skin, x, y, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
            this.renderPlayerDirectionIndicator(guiGraphics, (Point)screenPos, player.m_146908_());
        });
    }

    private void renderPlayerDirectionIndicator(GuiGraphics guiGraphics, Point centerPos, float yaw) {
        int indicatorSize = 10;
        float facingAngle = (yaw % 360.0f + 360.0f + 180.0f) % 360.0f;
        int baseAlpha = 255;
        int directionColor = baseAlpha << 24 | 0xFFFFFF;
        this.renderDirectionalPixels(guiGraphics, centerPos, indicatorSize, facingAngle, directionColor);
    }

    private void renderDirectionalPixels(GuiGraphics guiGraphics, Point center, int size, float facingAngle, int baseColor) {
        int half = size / 2;
        int left = center.x - half;
        int top = center.y - half;
        for (int i = 0; i < size * 4 - 4; ++i) {
            int y;
            int x;
            if (i < size) {
                x = left + i;
                y = top;
            } else if (i < size * 2 - 1) {
                x = left + size - 1;
                y = top + (i - size + 1);
            } else if (i < size * 3 - 2) {
                x = left + size - 1 - (i - (size * 2 - 2));
                y = top + size - 1;
            } else {
                x = left;
                y = top + size - 1 - (i - (size * 3 - 3));
            }
            float pixelAngle = this.getPixelAngle(center, new Point(x, y));
            if (!this.isWithinAngleRange(pixelAngle, facingAngle)) continue;
            int fadedColor = this.getFadedColor(baseColor, pixelAngle, facingAngle);
            fadedColor = this.applyGlobalFade(fadedColor);
            guiGraphics.m_280509_(x, y, x + 1, y + 1, fadedColor);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, TeleportHelper.TeleportDestination hoveredDestination, int mouseX, int mouseY) {
        if (this.screenAlpha < 0.8f) {
            return;
        }
        if (hoveredDestination != null) {
            long dist = Math.round(hoveredDestination.distance);
            long displayDist = dist > 1000L ? dist / 1000L : dist;
            MutableComponent text = Component.m_237110_((String)("gui.viaromana.distance_" + (dist > 1000L ? "kilometers" : "meters")), (Object[])new Object[]{hoveredDestination.name, displayDist});
            guiGraphics.m_280557_(this.f_96547_, (Component)text, mouseX, mouseY);
        } else if (this.isMouseOverPlayer(mouseX, mouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.player_marker"), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.screenAlpha < 0.5f) {
            return false;
        }
        if (button == 0) {
            TeleportHelper.TeleportDestination destination = this.findDestinationAtPosition(this.getRevealedNodes(), (int)mouseX, (int)mouseY);
            if (destination != null) {
                this.selectDestination(destination);
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void selectDestination(TeleportHelper.TeleportDestination destination) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (PlayerData.isChartingPath((Player)this.f_96541_.f_91074_)) {
            HudMessageManager.queueMessage("message.via_romana.cannot_warp_when_recording");
            this.m_7379_();
            return;
        }
        if (EffectUtils.hasEffect((Entity)this.f_96541_.f_91074_, "travellers_fatigue")) {
            HudMessageManager.queueMessage("message.via_romana.has_fatigue");
            this.m_7379_();
            return;
        }
        if (FadeManager.isActive()) {
            HudMessageManager.queueMessage("message.via_romana.cannot_warp_when_warping");
            this.m_7379_();
            return;
        }
        TeleportRequestC2S packet = new TeleportRequestC2S(this.signPos, destination.position);
        PacketBroadcaster.C2S.sendToServer((Packet)packet);
        this.m_7379_();
    }

    private void validateNodeSign(BlockPos nodePos) {
        if (!this.validatedNodes.contains(nodePos)) {
            SignValidationRequestC2S packet = new SignValidationRequestC2S(nodePos);
            PacketBroadcaster.C2S.sendToServer((Packet)packet);
        }
    }

    public void handleSignValidation(BlockPos nodePos, boolean isValid) {
        if (isValid) {
            this.validatedNodes.add(nodePos);
        }
    }

    private Set<BlockPos> getRevealedNodes() {
        HashSet<BlockPos> revealedNodes = new HashSet<BlockPos>(this.animatedNodes);
        this.nodesToAnimate.forEach(node -> revealedNodes.add(node.position));
        return revealedNodes;
    }

    private void calculateBounds() {
        if (this.networkNodeMap.isEmpty()) {
            assert (this.f_96541_ != null);
            BlockPos playerPos = this.f_96541_.f_91074_ != null ? this.f_96541_.f_91074_.m_20183_() : BlockPos.f_121853_;
            this.minBounds = playerPos.m_7918_(-128, 0, -128);
            this.maxBounds = playerPos.m_7918_(128, 0, 128);
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : this.networkNodeMap.keySet()) {
            minX = Math.min(minX, pos.m_123341_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        this.minBounds = new BlockPos(minX, 0, minZ);
        this.maxBounds = new BlockPos(maxX, 0, maxZ);
    }

    private void configureAnimationTiming() {
        this.totalAnimationWaves = this.computeAnimationWaveCount();
        float totalDurationSeconds = CommonConfig.spline_animation_time;
        this.totalAnimationDurationMillis = Math.max(1L, (long)(totalDurationSeconds * 1000.0f));
        this.completedAnimationWaves = 0;
        this.animationProgress = 0.0f;
        this.animationStartMillis = -1L;
    }

    private int computeAnimationWaveCount() {
        if (this.sourceNodePos == null || !this.networkNodeMap.containsKey(this.sourceNodePos)) {
            return 1;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> frontier = new ArrayDeque<BlockPos>();
        frontier.add(this.sourceNodePos);
        visited.add(this.sourceNodePos);
        int waves = 0;
        while (!frontier.isEmpty()) {
            int size = frontier.size();
            ++waves;
            for (int i = 0; i < size; ++i) {
                BlockPos current = (BlockPos)frontier.poll();
                DestinationResponseS2C.NodeNetworkInfo node = this.networkNodeMap.get(current);
                if (node == null) continue;
                for (BlockPos neighbor : node.connections) {
                    if (!visited.add(neighbor)) continue;
                    frontier.add(neighbor);
                }
            }
        }
        return Math.max(1, waves);
    }

    private Optional<Point> worldToScreen(BlockPos worldPos) {
        if (this.mapRenderer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mapRenderer.worldToScreen(worldPos, this.f_96543_, this.f_96544_));
    }

    private boolean isMouseOver(Point screenPos, int size, int mouseX, int mouseY) {
        int tolerance = size / 2;
        return Math.abs(mouseX - screenPos.x) <= tolerance && Math.abs(mouseY - screenPos.y) <= tolerance;
    }

    private boolean isMouseOverPlayer(int mouseX, int mouseY) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return false;
        }
        return this.worldToScreen(this.f_96541_.f_91074_.m_20183_()).map(screenPos -> this.isMouseOver((Point)screenPos, 8, mouseX, mouseY)).orElse(false);
    }

    private TeleportHelper.TeleportDestination findDestinationAtPosition(Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            Optional<Point> screenPosOpt;
            boolean isValidated;
            boolean bl = isValidated = this.validatedNodes.contains(dest.position) || this.sourceNodePos == null;
            if (!revealedNodes.contains(dest.position) || !isValidated || !(screenPosOpt = this.worldToScreen(dest.position)).isPresent() || !this.isMouseOver(screenPosOpt.get(), 16, mouseX, mouseY)) continue;
            return dest;
        }
        return null;
    }

    private float getPixelAngle(Point center, Point pixel) {
        return (float)((Math.toDegrees(Math.atan2(pixel.x - center.x, center.y - pixel.y)) + 360.0) % 360.0);
    }

    private boolean isWithinAngleRange(float angle, float target) {
        float diff = Math.abs(angle - target);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        return diff <= 45.0f;
    }

    private int getFadedColor(int baseColor, float pixelAngle, float facingAngle) {
        float diff = Math.abs(pixelAngle - facingAngle);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        float fadeFactor = (float)Math.pow(1.0f - diff / 45.0f, 1.0);
        fadeFactor = Math.max(0.0f, Math.min(1.0f, fadeFactor));
        int alpha = baseColor >> 24 & 0xFF;
        int fadedAlpha = (int)((float)alpha * fadeFactor);
        return fadedAlpha << 24 | baseColor & 0xFFFFFF;
    }

    public void m_7379_() {
        if (this.mapTexture != null) {
            this.mapTexture.close();
            this.mapTexture = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.close();
            this.mapRenderer = null;
        }
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

