/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.elements.MapActionButton;
import net.rasanovum.viaromana.client.gui.elements.MapButtonGroup;
import net.rasanovum.viaromana.client.gui.elements.MapCycleButton;
import net.rasanovum.viaromana.client.gui.elements.MapEditBox;
import net.rasanovum.viaromana.client.gui.elements.MapIconButton;
import net.rasanovum.viaromana.client.gui.elements.MapIconButtonGroup;
import net.rasanovum.viaromana.client.gui.elements.MapSignatureButton;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.SignLinkRequestC2S;
import net.rasanovum.viaromana.network.packets.SignUnlinkRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class LinkSignScreen
extends Screen {
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int USABLE_WIDTH = 230;
    private static final int USABLE_HEIGHT = 160;
    private static final ResourceLocation BACKGROUND_TEXTURE = VersionUtils.getLocation("via_romana:textures/screens/background_map.png");
    private final BlockPos nodePos;
    private final BlockPos signPos;
    private final UUID playerUuid;
    private final String playerName;
    private final boolean isTempNode;
    private final boolean isSignLinked;
    private MapEditBox destinationNameField;
    private MapButtonGroup<Node.LinkType> linkTypeButtonGroup;
    private MapCycleButton<Node.LinkType> destinationButton;
    private MapCycleButton<Node.LinkType> privateButton;
    private MapCycleButton<Node.LinkType> accessButton;
    private MapIconButtonGroup iconButtonGroup;
    private MapSignatureButton signatureButton;
    private MapActionButton unlinkButton;
    private String destinationName = "Travel Destination";
    private Node.LinkType linkType = Node.LinkType.DESTINATION;
    private Node.Icon icon = Node.Icon.SIGNPOST;

    public LinkSignScreen(Player player, LinkHandler.LinkData linkData, boolean isTempNode, boolean isSignLinked) {
        super((Component)Component.m_237115_((String)"gui.viaromana.configure_sign_link.title"));
        this.playerUuid = player.m_20148_();
        this.playerName = player.m_7755_().getString();
        this.signPos = linkData.signPos();
        this.nodePos = linkData.nodePos();
        this.linkType = linkData.linkType() != null ? linkData.linkType() : Node.LinkType.DESTINATION;
        this.icon = linkData.icon() != null ? linkData.icon() : Node.Icon.SIGNPOST;
        this.destinationName = linkData.destinationName() != null ? linkData.destinationName() : "Travel Destination";
        this.isTempNode = isTempNode;
        this.isSignLinked = isSignLinked;
    }

    protected void m_7856_() {
        super.m_7856_();
        int panelX = (this.f_96543_ - 256) / 2;
        int panelY = (this.f_96544_ - 256) / 2;
        int usableX = panelX + 13;
        int usableY = panelY + 48;
        this.destinationNameField = new MapEditBox(this.f_96547_, usableX + 10, (usableY -= 8) + 30, 210, 20, (Component)Component.m_237115_((String)"gui.viaromana.destination_name"));
        this.destinationNameField.m_94144_(this.destinationName);
        this.destinationNameField.m_94199_(50);
        this.destinationNameField.m_94202_(4139547);
        this.m_142416_((GuiEventListener)this.destinationNameField);
        this.linkTypeButtonGroup = new MapButtonGroup<Node.LinkType>(value -> {
            this.linkType = value;
        });
        int buttonWidth = 75;
        int buttonHeight = 16;
        int buttonStartX = usableX + 10;
        this.destinationButton = new MapCycleButton<Node.LinkType>(this.f_96547_, buttonStartX, usableY + 74, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.DESTINATION), Node.LinkType.DESTINATION, linkType -> Component.m_237115_((String)"gui.viaromana.destination_button"), null, (Component)Component.m_237115_((String)"gui.viaromana.destination_tooltip"));
        this.privateButton = new MapCycleButton<Node.LinkType>(this.f_96547_, buttonStartX, usableY + 94, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.PRIVATE), Node.LinkType.PRIVATE, linkType -> Component.m_237115_((String)"gui.viaromana.private_button"), null, (Component)Component.m_237115_((String)"gui.viaromana.private_tooltip"));
        this.accessButton = new MapCycleButton<Node.LinkType>(this.f_96547_, buttonStartX, usableY + 114, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.ACCESS), Node.LinkType.ACCESS, linkType -> Component.m_237115_((String)"gui.viaromana.access_button"), null, (Component)Component.m_237115_((String)"gui.viaromana.access_tooltip"));
        this.linkTypeButtonGroup.addButton(this.destinationButton);
        this.linkTypeButtonGroup.addButton(this.privateButton);
        this.linkTypeButtonGroup.addButton(this.accessButton);
        this.linkTypeButtonGroup.selectByValue(this.linkType);
        this.m_142416_((GuiEventListener)this.destinationButton);
        this.m_142416_((GuiEventListener)this.privateButton);
        this.m_142416_((GuiEventListener)this.accessButton);
        int iconGridX = usableX + 115 - 20;
        int iconGridY = usableY + 70;
        this.iconButtonGroup = new MapIconButtonGroup(value -> {
            this.icon = value;
        });
        List<MapIconButton> iconButtons = this.iconButtonGroup.createIconButtons(this.f_96547_, iconGridX, iconGridY, 4, 0);
        for (MapIconButton iconBtn : iconButtons) {
            this.m_142416_((GuiEventListener)iconBtn);
        }
        this.iconButtonGroup.selectByIcon(this.icon);
        this.signatureButton = new MapSignatureButton(this.f_96547_, usableX + 10, usableY + 146, 130, this.playerName, value -> this.confirmLinking());
        this.m_142416_((GuiEventListener)this.signatureButton);
        if (this.isSignLinked) {
            int unlinkButtonWidth = 60;
            int unlinkButtonHeight = 16;
            this.unlinkButton = new MapActionButton(usableX + 230 - unlinkButtonWidth - 10, usableY + 148, unlinkButtonWidth, unlinkButtonHeight, (Component)Component.m_237115_((String)"gui.viaromana.unlink_button"), (Component)Component.m_237115_((String)"gui.viaromana.unlink_tooltip"), value -> {
                PacketBroadcaster.C2S.sendToServer((Packet)new SignUnlinkRequestC2S(this.signPos));
                this.m_7379_();
            }, VersionUtils.getLocation("via_romana:textures/screens/element_unlink.png"));
            this.m_142416_((GuiEventListener)this.unlinkButton);
        }
        this.m_264313_((GuiEventListener)this.destinationNameField);
    }

    public void m_86600_() {
        super.m_86600_();
        this.destinationNameField.m_94120_();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int panelX = (this.f_96543_ - 256) / 2;
        int panelY = (this.f_96544_ - 256) / 2;
        int usableX = panelX + 13;
        int usableY = panelY + 48;
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, panelX, panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        MutableComponent title = Component.m_237115_((String)"gui.viaromana.configure_sign_link.title");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)title);
        guiGraphics.m_280614_(this.f_96547_, (Component)title, usableX + (230 - titleWidth) / 2, (usableY -= 8) + 10, 4139547, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.name_label"), usableX + 10, usableY + 20, 4139547, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.type_label"), usableX + 10, usableY + 60, 4139547, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.icon_label"), usableX + 115 - 20, usableY + 60, 4139547, false);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.signature_label"), usableX + 10, usableY + 138, 4139547, false);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void confirmLinking() {
        Node.Icon selectedIcon;
        Node.LinkType selectedLinkType;
        String finalName = this.destinationNameField.m_94155_().trim();
        if (finalName.isEmpty()) {
            finalName = Component.m_237115_((String)"gui.viaromana.default_destination_name").getString();
        }
        if ((selectedLinkType = this.linkType) == null) {
            selectedLinkType = Node.LinkType.DESTINATION;
        }
        if ((selectedIcon = this.icon) == null) {
            selectedIcon = Node.Icon.SIGNPOST;
        }
        UUID owner = selectedLinkType == Node.LinkType.PRIVATE ? this.playerUuid : null;
        LinkHandler.LinkData linkData = new LinkHandler.LinkData(this.signPos, this.nodePos, selectedLinkType, selectedIcon, finalName, owner);
        SignLinkRequestC2S packet = new SignLinkRequestC2S(linkData, this.isTempNode);
        PacketBroadcaster.C2S.sendToServer((Packet)packet);
        ClientPathData clientPathData = ClientPathData.getInstance();
        boolean isTargetNodeTemp = clientPathData.isTemporaryNode(this.nodePos);
        boolean hasExistingTempLink = clientPathData.getTemporarySignLink(this.signPos).isPresent();
        if (isTargetNodeTemp || hasExistingTempLink) {
            clientPathData.addTemporaryLink(linkData);
        } else if (hasExistingTempLink && !isTargetNodeTemp) {
            clientPathData.getTemporarySignLink(this.signPos).ifPresent(clientPathData::removeTemporaryLink);
        }
        this.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.destinationNameField.m_93696_()) {
            this.confirmLinking();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

