/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;

final class ReqExclBulkScorer
extends BulkScorer {
    private final BulkScorer req;
    private final DocIdSetIterator excl;

    ReqExclBulkScorer(BulkScorer req, DocIdSetIterator excl) {
        this.req = req;
        this.excl = excl;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int upTo = min;
        int exclDoc = this.excl.docID();
        while (upTo < max) {
            if (exclDoc < upTo) {
                exclDoc = this.excl.advance(upTo);
            }
            if (exclDoc == upTo) {
                ++upTo;
                exclDoc = this.excl.nextDoc();
                continue;
            }
            upTo = this.req.score(collector, acceptDocs, upTo, Math.min(exclDoc, max));
        }
        if (upTo == max) {
            upTo = this.req.score(collector, acceptDocs, upTo, upTo);
        }
        return upTo;
    }

    @Override
    public long cost() {
        return this.req.cost();
    }
}

