/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import guideme.Guide;
import guideme.PageAnchor;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideScreen;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.GuideSearchScreen;
import java.net.URI;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuideNavigation {
    private static final Logger LOG = LoggerFactory.getLogger(GuideNavigation.class);

    private GuideNavigation() {
    }

    public static void navigateTo(Guide guide, PageAnchor anchor) {
        GuideScreen guideScreen;
        GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
        Screen currentScreen = GuideNavigation.getCurrentGuideMeScreen();
        Screen screenToReturnTo = null;
        if (currentScreen instanceof GuideScreen) {
            guideScreen = (GuideScreen)currentScreen;
            screenToReturnTo = guideScreen.getReturnToOnClose();
        } else if (currentScreen instanceof GuideSearchScreen) {
            GuideSearchScreen searchScreen = (GuideSearchScreen)currentScreen;
            screenToReturnTo = searchScreen.getReturnToOnClose();
        } else {
            screenToReturnTo = Minecraft.m_91087_().f_91080_;
        }
        if (GuideSearchScreen.PAGE_ID.equals((Object)anchor.pageId())) {
            GuideSearchScreen guiScreen = GuideSearchScreen.open(guide, anchor.anchor());
            guiScreen.setReturnToOnClose(screenToReturnTo);
            Minecraft.m_91087_().m_91152_((Screen)guiScreen);
            return;
        }
        if (currentScreen instanceof GuideScreen && (guideScreen = (GuideScreen)currentScreen).getGuide() == guide) {
            if (Objects.equals(guideScreen.getCurrentPageId(), anchor.pageId())) {
                guideScreen.scrollToAnchor(anchor.anchor());
                if (anchor.anchor() != null) {
                    history.push(anchor);
                }
            } else {
                guideScreen.loadPageAndScrollTo(anchor);
                history.push(anchor);
            }
            return;
        }
        guideScreen = GuideScreen.openNew(guide, anchor, history);
        guideScreen.setReturnToOnClose(screenToReturnTo);
        Minecraft.m_91087_().m_91152_((Screen)guideScreen);
    }

    @Nullable
    private static Screen getCurrentGuideMeScreen() {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof GuideScreen || currentScreen instanceof GuideSearchScreen) {
            return currentScreen;
        }
        return null;
    }

    public static void navigateForward(Guide guide) {
        GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
        history.forward().ifPresent(pageAnchor -> GuideNavigation.navigateTo(guide, pageAnchor));
    }

    public static void navigateBack(Guide guide) {
        GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
        history.back().ifPresent(pageAnchor -> GuideNavigation.navigateTo(guide, pageAnchor));
    }

    public static void openUrl(String href) {
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("Can't parse '{}' as URL", (Object)href);
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen previousScreen = minecraft.f_91080_;
        if (uri.getScheme() != null) {
            if (((Boolean)minecraft.f_91066_.m_231816_().m_231551_()).booleanValue()) {
                minecraft.m_91152_((Screen)new ConfirmLinkScreen(doOpen -> {
                    if (doOpen) {
                        Util.m_137581_().m_137648_(uri);
                    }
                    minecraft.m_91152_(previousScreen);
                }, href, false));
            } else {
                Util.m_137581_().m_137648_(uri);
            }
        } else {
            LOG.debug("Can't open relative URL: '{}'", (Object)href);
        }
    }
}

