/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data;

import me.wesley1808.servercore.common.config.serialization.TextColorSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.ConfSerialisers;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

@ConfSerialisers(value={TextColorSerializer.class})
public interface CommandConfig {
    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="status-enabled")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Enables the /servercore status command."})
    public boolean statusCommandEnabled();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="mobcaps-enabled")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Enables the /mobcaps command."})
    public boolean mobcapsCommandEnabled();

    @AnnotationBasedSorter.Order(value=3)
    @ConfKey(value="colors.primary")
    @ConfDefault.DefaultObject(value="defaultPrimaryColor")
    @ConfComments(value={"The colors used in command feedback. You can use hex codes or minecraft legacy color names.", "The primary color is the most used color in command feedback."})
    public TextColor primaryColor();

    @AnnotationBasedSorter.Order(value=4)
    @ConfKey(value="colors.secondary")
    @ConfDefault.DefaultObject(value="defaultSecondaryColor")
    @ConfComments(value={"The secondary color is used for highlighting important information, like values."})
    public TextColor secondaryColor();

    @AnnotationBasedSorter.Order(value=5)
    @ConfKey(value="colors.tertiary")
    @ConfDefault.DefaultObject(value="defaultTertiaryColor")
    @ConfComments(value={"The tertiary color is mostly used for text in titles."})
    public TextColor tertiaryColor();

    default public String primaryHex() {
        return this.primaryColor().m_131274_();
    }

    default public String secondaryHex() {
        return this.secondaryColor().m_131274_();
    }

    default public String tertiaryHex() {
        return this.tertiaryColor().m_131274_();
    }

    default public int primaryValue() {
        return this.primaryColor().m_131265_();
    }

    default public int secondaryValue() {
        return this.secondaryColor().m_131265_();
    }

    default public int tertiaryValue() {
        return this.tertiaryColor().m_131265_();
    }

    public static TextColor defaultPrimaryColor() {
        return TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_AQUA);
    }

    public static TextColor defaultSecondaryColor() {
        return TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN);
    }

    public static TextColor defaultTertiaryColor() {
        return TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA);
    }
}

