/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.platform.network;

import com.google.common.collect.EnumBiMap;
import com.mrcrayfish.framework.api.network.FrameworkNetwork;
import com.mrcrayfish.framework.api.network.FrameworkNetworkBuilder;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.MessageDirection;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.framework.network.message.LoginIndexHolder;
import com.mrcrayfish.framework.platform.network.ForgeMessageContext;
import com.mrcrayfish.framework.platform.network.ForgeNetwork;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeNetworkBuilder
implements FrameworkNetworkBuilder {
    private static final EnumBiMap<MessageDirection, NetworkDirection> DIRECTION_MAPPER = (EnumBiMap)Util.m_137469_((Object)EnumBiMap.create(MessageDirection.class, NetworkDirection.class), map -> {
        map.put((Object)MessageDirection.PLAY_CLIENT_BOUND, (Object)NetworkDirection.PLAY_TO_CLIENT);
        map.put((Object)MessageDirection.PLAY_SERVER_BOUND, (Object)NetworkDirection.PLAY_TO_SERVER);
        map.put((Object)MessageDirection.HANDSHAKE_CLIENT_BOUND, (Object)NetworkDirection.LOGIN_TO_CLIENT);
        map.put((Object)MessageDirection.HANDSHAKE_SERVER_BOUND, (Object)NetworkDirection.LOGIN_TO_SERVER);
    });
    private final ResourceLocation id;
    private final int version;
    private boolean requiresClient = true;
    private boolean requiresServer = true;
    private final AtomicInteger idCount = new AtomicInteger(1);
    private final List<Consumer<SimpleChannel>> playMessages = new ArrayList<Consumer<SimpleChannel>>();
    private final List<Consumer<SimpleChannel>> handshakeMessages = new ArrayList<Consumer<SimpleChannel>>();

    public ForgeNetworkBuilder(ResourceLocation id, int version) {
        this.id = id;
        this.version = version;
    }

    @Override
    public ForgeNetworkBuilder ignoreClient() {
        this.requiresClient = false;
        return this;
    }

    @Override
    public ForgeNetworkBuilder ignoreServer() {
        this.requiresServer = false;
        return this;
    }

    @Override
    public <T extends PlayMessage<T>> ForgeNetworkBuilder registerPlayMessage(Class<T> messageClass) {
        return this.registerPlayMessage((Class)messageClass, (MessageDirection)null);
    }

    @Override
    public <T extends PlayMessage<T>> ForgeNetworkBuilder registerPlayMessage(Class<T> messageClass, @Nullable MessageDirection direction) {
        try {
            Constructor<T> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            PlayMessage message = (PlayMessage)constructor.newInstance(new Object[0]);
            NetworkDirection networkDirection = (NetworkDirection)DIRECTION_MAPPER.get((Object)direction);
            this.playMessages.add(channel -> channel.registerMessage(this.idCount.getAndIncrement(), messageClass, message::encode, message::decode, (msg, context) -> {
                MessageDirection dir = (MessageDirection)((Object)((Object)((Object)DIRECTION_MAPPER.inverse().get((Object)((NetworkEvent.Context)context.get()).getDirection()))));
                ForgeMessageContext messageContext = new ForgeMessageContext((NetworkEvent.Context)context.get(), dir);
                message.handle(msg, messageContext);
                IMessage reply = messageContext.getReply();
                if (reply != null) {
                    channel.reply((Object)reply, (NetworkEvent.Context)context.get());
                }
            }, Optional.ofNullable(networkDirection)));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public <T extends HandshakeMessage<T>> ForgeNetworkBuilder registerHandshakeMessage(Class<T> messageClass, boolean sendOnHandshake) {
        return this.registerHandshakeMessage((Class)messageClass, sendOnHandshake ? FrameworkNetworkBuilder.createHandshakeMessageSupplier(messageClass) : null);
    }

    @Override
    public <T extends HandshakeMessage<T>> ForgeNetworkBuilder registerHandshakeMessage(Class<T> messageClass, @Nullable Function<Boolean, List<Pair<String, T>>> messages) {
        try {
            Constructor<T> constructor = messageClass.getDeclaredConstructor(new Class[0]);
            HandshakeMessage message = (HandshakeMessage)constructor.newInstance(new Object[0]);
            this.handshakeMessages.add(channel -> {
                SimpleChannel.MessageBuilder builder = channel.messageBuilder(messageClass, this.idCount.getAndIncrement());
                builder.loginIndex(LoginIndexHolder::getLoginIndex, LoginIndexHolder::setLoginIndex);
                builder.encoder(message::encode);
                builder.decoder(message::decode);
                builder.consumerNetworkThread((msg, context) -> {
                    MessageDirection direction = (MessageDirection)((Object)((Object)((Object)DIRECTION_MAPPER.inverse().get((Object)((NetworkEvent.Context)context.get()).getDirection()))));
                    ForgeMessageContext messageContext = new ForgeMessageContext((NetworkEvent.Context)context.get(), direction);
                    msg.handle(msg, messageContext);
                    IMessage reply = messageContext.getReply();
                    if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.LOGIN_TO_CLIENT) {
                        Objects.requireNonNull(reply, "Handshake messages received on the client must reply with an acknowledgement/message");
                        channel.reply((Object)reply, (NetworkEvent.Context)context.get());
                    }
                });
                if (messages != null) {
                    builder.buildLoginPacketList(messages);
                }
                builder.add();
            });
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The message %s is missing an empty parameter constructor", messageClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Unable to access the constructor of %s. Make sure the constructor is public.", messageClass.getName()), e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this;
    }

    private void registerAckMessage(SimpleChannel channel) {
        HandshakeMessage.Acknowledge acknowledge = new HandshakeMessage.Acknowledge();
        channel.messageBuilder(HandshakeMessage.Acknowledge.class, this.idCount.getAndIncrement()).loginIndex(LoginIndexHolder::getLoginIndex, LoginIndexHolder::setLoginIndex).decoder(acknowledge::decode).encoder(acknowledge::encode).consumerNetworkThread((acknowledge1, context) -> HandshakeHandler.indexFirst((handler, msg, s) -> {
            MessageDirection direction = (MessageDirection)((Object)((Object)((Object)DIRECTION_MAPPER.inverse().get((Object)((NetworkEvent.Context)s.get()).getDirection()))));
            acknowledge.handle((HandshakeMessage.Acknowledge)acknowledge1, (MessageContext)new ForgeMessageContext((NetworkEvent.Context)s.get(), direction));
        }).accept(acknowledge1, context)).add();
    }

    @Override
    public FrameworkNetwork build() {
        this.idCount.set(1);
        boolean ignoreClient = !this.requiresClient;
        boolean ignoreServer = !this.requiresServer;
        String protocolVersion = Integer.toString(this.version);
        SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.id).networkProtocolVersion(() -> protocolVersion).clientAcceptedVersions(s -> ignoreServer || protocolVersion.equals(s)).serverAcceptedVersions(s -> ignoreClient || protocolVersion.equals(s)).simpleChannel();
        this.playMessages.forEach(consumer -> consumer.accept(channel));
        if (this.handshakeMessages.size() > 0) {
            this.registerAckMessage(channel);
        }
        this.handshakeMessages.forEach(consumer -> consumer.accept(channel));
        return new ForgeNetwork(channel);
    }
}

