/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.slf4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger f_126421_ = LogUtils.getLogger();
    private final Iterable<Path> f_243763_;
    private final PackOutput f_243685_;

    public NbtToSnbt(PackOutput p_250442_, Collection<Path> p_249158_) {
        this.f_243763_ = p_249158_;
        this.f_243685_ = p_250442_;
    }

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput p_254274_) {
        Path $$1 = this.f_243685_.m_245114_();
        ArrayList<CompletionStage> $$2 = new ArrayList<CompletionStage>();
        for (Path $$3 : this.f_243763_) {
            $$2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> $$3 = Files.walk($$3, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])$$3.filter(p_126430_ -> p_126430_.toString().endsWith(".nbt")).map(p_253418_ -> CompletableFuture.runAsync(() -> NbtToSnbt.m_236381_(p_254274_, p_253418_, NbtToSnbt.m_126435_($$3, p_253418_), $$1), Util.m_183992_())).toArray(CompletableFuture[]::new));
                        if ($$3 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if ($$3 != null) {
                                try {
                                    $$3.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException $$4) {
                            f_126421_.error("Failed to read structure input directory", (Throwable)$$4);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    $$3.close();
                }
                return completableFuture;
            }, Util.m_183991_()).thenCompose(p_253420_ -> p_253420_));
        }
        return CompletableFuture.allOf((CompletableFuture[])$$2.toArray(CompletableFuture[]::new));
    }

    @Override
    public final String m_6055_() {
        return "NBT -> SNBT";
    }

    private static String m_126435_(Path p_126436_, Path p_126437_) {
        String $$2 = p_126436_.relativize(p_126437_).toString().replaceAll("\\\\", "/");
        return $$2.substring(0, $$2.length() - ".nbt".length());
    }

    @Nullable
    public static Path m_236381_(CachedOutput p_236382_, Path p_236383_, String p_236384_, Path p_236385_) {
        Path path;
        block8: {
            InputStream $$4 = Files.newInputStream(p_236383_, new OpenOption[0]);
            try {
                Path $$5 = p_236385_.resolve(p_236384_ + ".snbt");
                NbtToSnbt.m_236377_(p_236382_, $$5, NbtUtils.m_178063_(NbtIo.m_128939_($$4)));
                f_126421_.info("Converted {} from NBT to SNBT", (Object)p_236384_);
                path = $$5;
                if ($$4 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if ($$4 != null) {
                        try {
                            $$4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$6) {
                    f_126421_.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{p_236384_, p_236383_, $$6});
                    return null;
                }
            }
            $$4.close();
        }
        return path;
    }

    public static void m_236377_(CachedOutput p_236378_, Path p_236379_, String p_236380_) throws IOException {
        ByteArrayOutputStream $$3 = new ByteArrayOutputStream();
        HashingOutputStream $$4 = new HashingOutputStream(Hashing.sha1(), (OutputStream)$$3);
        $$4.write(p_236380_.getBytes(StandardCharsets.UTF_8));
        $$4.write(10);
        p_236378_.m_213871_(p_236379_, $$3.toByteArray(), $$4.hash());
    }
}

