/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.research;

import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.client.gui.WindowSelectRes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IResearchCost;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ResearchCostSelector {
    private final BOWindow origin;
    private final IGlobalResearch research;
    private final List<IResearchCost> costs;
    private final Consumer<List<ItemStorage>> consumer;
    private List<ItemStorage> selectedCosts;

    public static void open(BOWindow origin, IGlobalResearch research, Consumer<List<ItemStorage>> consumer) {
        new ResearchCostSelector(origin, research, consumer).open();
    }

    private ResearchCostSelector(BOWindow origin, IGlobalResearch research, Consumer<List<ItemStorage>> consumer) {
        this.origin = origin;
        this.research = research;
        this.costs = this.research.getCostList();
        this.consumer = consumer;
    }

    public void open() {
        this.selectedCosts = new ArrayList<ItemStorage>();
        this.cycle();
    }

    private void cycle() {
        int costsCount = this.costs.size();
        while (this.selectedCosts.size() < costsCount) {
            IResearchCost cost = this.costs.get(this.selectedCosts.size());
            List items = cost.getItems();
            if (items.size() > 1) {
                new WindowSelectRes(this.origin, (Component)Component.m_237110_((String)"minecolonies_tweaks.gui.select_research_cost", (Object[])new Object[]{cost.getTranslatedName()}), null, items.stream().map(ItemStack::new).toList(), (stack, count) -> {
                    this.selectedCosts.add(new ItemStorage(stack, cost.getCount()));
                    this.cycle();
                }).open();
                break;
            }
            this.selectedCosts.add(new ItemStorage((Item)items.get(0), cost.getCount()));
        }
        if (this.selectedCosts.size() == costsCount) {
            this.consumer.accept(new ArrayList<ItemStorage>(this.selectedCosts));
        }
    }
}

