/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCost;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostResolver;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class ResearchCostRequestMessage
extends AbstractMessage {
    private final BuildingPos buildingPos;
    private final ResourceLocation branch;
    private final ResourceLocation research;
    private final List<ItemStorage> items;

    public ResearchCostRequestMessage(BuildingPos buildingPos, ResourceLocation branch, ResourceLocation research, List<ItemStorage> items) {
        this.buildingPos = buildingPos;
        this.branch = branch;
        this.research = research;
        this.items = new ArrayList<ItemStorage>(items);
    }

    public ResearchCostRequestMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.buildingPos = new BuildingPos(buffer);
        this.branch = buffer.m_130281_();
        this.research = buffer.m_130281_();
        this.items = buffer.m_236845_(SerializationHelper.deserializer());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        this.buildingPos.serializeBuffer(buffer);
        buffer.m_130085_(this.branch);
        buffer.m_130085_(this.research);
        buffer.m_236828_(this.items, SerializationHelper.serializer());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        IGlobalResearch research;
        super.handle(context);
        ServerPlayer player = context.getSender();
        IBuilding building = this.buildingPos.getBuilding();
        if (!ResearchCostResolver.hasResolver(building)) {
            player.m_213846_((Component)Component.m_237113_((String)"Resolver not exist").m_130940_(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        if (ResearchCost.isRequested(building, this.branch, this.research)) {
            player.m_213846_((Component)Component.m_237115_((String)"minecolonies_tweaks.gui.already_requested").m_130940_(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        IGlobalResearchTree tree = IGlobalResearchTree.getInstance();
        IGlobalResearchBranch branch = tree.getBranchData(this.branch);
        IGlobalResearch iGlobalResearch = research = branch != null ? tree.getResearch(this.branch, this.research) : null;
        if (research == null) {
            player.m_213846_((Component)Component.m_237110_((String)"minecolonies_tweaks.gui.research_not_found", (Object[])new Object[]{this.branch, this.research}).m_130940_(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        player.m_213846_((Component)Component.m_237110_((String)"minecolonies_tweaks.gui.research_cost_requested", (Object[])new Object[]{MutableComponent.m_237204_((ComponentContents)branch.getName()), MutableComponent.m_237204_((ComponentContents)research.getName())}).m_130940_(ChatFormatting.GRAY));
        ResearchCost request = new ResearchCost(this.branch, this.research, this.items, player.m_20148_());
        building.createRequest((IRequestable)new CustomizableRequestable(request), true);
        SoundUtils.playSuccessSound((Player)player, (BlockPos)building.getPosition());
    }

    public BuildingPos getBuildingPos() {
        return this.buildingPos;
    }

    public ResourceLocation getBranch() {
        return this.branch;
    }

    public ResourceLocation getResearch() {
        return this.research;
    }

    public List<ItemStorage> getItems() {
        return this.items;
    }
}

