/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.ItemResourceScrollAccessor;

public class ResourceScrollElement
extends ResourceScrollBookElement {
    private Component workerName = EMPTY;
    private Component constructionName = EMPTY;
    private Component progress = EMPTY;

    public ResourceScrollElement(ItemStack stack) {
        super(stack);
    }

    @Override
    public void onOpenClicked() {
        super.onOpenClicked();
        CompoundTag compound = this.stack.m_41784_();
        Minecraft mc = Minecraft.m_91087_();
        ItemResourceScrollAccessor.invokeOpenWindow(compound, (Player)mc.f_91074_);
    }

    @Override
    public void update() {
        super.update();
        BuildingBuilder.View buildingView = this.getBuildingView();
        if (buildingView == null) {
            this.workerName = EMPTY;
            this.constructionName = BUILDER_NOT_SETTED;
            this.progress = EMPTY;
            return;
        }
        this.valid = true;
        this.workerName = Component.m_237110_((String)"%s (lvl. %s)", (Object[])new Object[]{buildingView.getWorkerName(), buildingView.getBuildingLevel()}).m_130940_(ChatFormatting.DARK_PURPLE);
        BuildingResourcesModuleView resourceView = (BuildingResourcesModuleView)buildingView.getModuleViewByType(BuildingResourcesModuleView.class);
        IWorkOrderView workOrderView = buildingView.getColony().getWorkOrder(resourceView.getWorkOrderId());
        this.constructionName = workOrderView != null ? Component.m_237113_((String)workOrderView.getDisplayName().getString().replace("\n", " ")) : Component.m_237119_();
        double supplied = 0.0;
        double total = 0.0;
        for (BuildingBuilderResource resource : resourceView.getResources().values()) {
            supplied += (double)Math.min(resource.getAvailable(), resource.getAmount());
            total += (double)resource.getAmount();
        }
        this.progress = total > 0.0 ? Component.m_237110_((String)"com.minecolonies.coremod.gui.progress.res", (Object[])new Object[]{(int)(supplied / total * 100.0) + "%", resourceView.getProgress() + "%"}) : EMPTY;
    }

    @Override
    public void update(int index, Pane rowPane) {
        super.update(index, rowPane);
        this.getDesc1Label(rowPane).setText(this.workerName);
        this.getDesc2Label(rowPane).setText(this.constructionName);
        this.getDesc3Label(rowPane).setText(this.progress);
        this.getTooltip2(rowPane).setText(this.constructionName);
    }

    public BuildingBuilder.View getBuildingView() {
        CompoundTag compound = this.stack.m_41783_();
        if (compound != null) {
            BlockPos builderPos;
            int colonyId = compound.m_128451_("colony");
            BlockPos blockPos = builderPos = compound.m_128441_("builder") ? BlockPosUtil.read((CompoundTag)compound, (String)"builder") : null;
            if (builderPos != null) {
                IBuildingView iBuildingView;
                Minecraft mc = Minecraft.m_91087_();
                IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, mc.f_91073_.m_46472_());
                if (colonyView != null && (iBuildingView = colonyView.getBuilding(builderPos)) instanceof BuildingBuilder.View) {
                    BuildingBuilder.View buildingView = (BuildingBuilder.View)iBuildingView;
                    return buildingView;
                }
            }
        }
        return null;
    }
}

