/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingEmptySlotCounter;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;
import steve_gall.minecolonies_tweaks.core.common.item.ItemBuildingLinkScroll;

public class InventoryScrollElement
extends ResourceScrollBookElement {
    private Component buildingName = EMPTY;
    private Component text1 = EMPTY;
    private Component text2 = EMPTY;
    private BuildingEmptySlotCounter slotCounter;

    public InventoryScrollElement(ItemStack stack) {
        super(stack);
    }

    @Override
    public void onOpenClicked() {
        super.onOpenClicked();
        ((ItemBuildingLinkScroll)this.stack.m_41720_()).openWindow(this.stack, null);
    }

    @Override
    public void update() {
        super.update();
        IBuildingView buildingView = this.getBuildingView();
        if (buildingView == null) {
            this.buildingName = EMPTY;
            this.text1 = BUILDING_IS_MISSING;
            this.text2 = EMPTY;
            this.slotCounter = null;
            return;
        }
        this.valid = true;
        this.buildingName = Component.m_237119_().m_7220_((Component)BuildingUtils.getDisplayName(buildingView)).m_130940_(ChatFormatting.DARK_PURPLE);
        if (this.slotCounter == null || this.slotCounter.getBuildingView() != buildingView) {
            this.slotCounter = new BuildingEmptySlotCounter(buildingView);
        }
        if (this.slotCounter.update()) {
            this.text1 = this.slotCounter.getSlotsText();
            this.text2 = Component.m_237113_((String)("(" + this.slotCounter.getPercentText() + ")"));
        }
    }

    @Override
    public void update(int index, Pane rowPane) {
        super.update(index, rowPane);
        this.getDesc1Label(rowPane).setText(this.buildingName);
        this.getDesc2Label(rowPane).setText(this.text1);
        this.getDesc3Label(rowPane).setText(this.text2);
        if (this.slotCounter != null) {
            MutableComponent tooltip = Component.m_237119_().m_7220_(this.text1).m_130946_(" ").m_7220_(this.text2);
            this.getTooltip2(rowPane).setText(tooltip);
            this.getTooltip3(rowPane).setText(tooltip);
        }
    }

    @Nullable
    public IBuildingView getBuildingView() {
        BuildingPos pos = ItemBuildingLinkScroll.getPos(this.stack);
        return pos != null ? pos.getBuildingView() : null;
    }
}

