/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.emi.terminalstorage;

import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageEmiStackProvider
implements EmiStackProvider<Screen> {
    public EmiStackInteraction getStackAt(Screen screen, int mouseX, int mouseY) {
        if (screen instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage containerScreen = (ContainerScreenTerminalStorage)screen;
            return this.createClickableIngredient(containerScreen, mouseX, mouseY);
        }
        return EmiStackInteraction.EMPTY;
    }

    private <T> EmiStackInteraction createClickableIngredient(ContainerScreenTerminalStorage<T, ?> containerScreen, int mouseX, int mouseY) {
        int slotIndex = containerScreen.getStorageSlotIndexAtPosition(mouseX, mouseY);
        Optional<TerminalStorageTabIngredientComponentClient> tabOptional = containerScreen.getSelectedClientTab().filter(TerminalStorageTabIngredientComponentClient.class::isInstance).map(TerminalStorageTabIngredientComponentClient.class::cast);
        if (slotIndex >= 0 && tabOptional.isPresent()) {
            TerminalStorageTabIngredientComponentClient tab = tabOptional.get();
            int channel = ((ContainerTerminalStorageBase)((Object)containerScreen.getMenu())).getSelectedChannel();
            Optional<Object> instanceOptional = tab.getSlotInstance(channel, slotIndex);
            return instanceOptional.map(instance -> {
                EmiStack emiStack;
                if (instance instanceof ItemStack) {
                    ItemStack itemStack = (ItemStack)instance;
                    emiStack = EmiStack.of((ItemStack)itemStack);
                } else if (instance instanceof FluidStack) {
                    FluidStack fluidStack = (FluidStack)instance;
                    emiStack = EmiStack.of((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount());
                } else {
                    emiStack = EmiStack.EMPTY;
                }
                return new EmiStackInteraction((EmiIngredient)emiStack, null, false);
            }).orElse(EmiStackInteraction.EMPTY);
        }
        return EmiStackInteraction.EMPTY;
    }
}

