/*
 * Decompiled with CFR 0.152.
 */
package net.zsemper.thermalprocessing.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.zsemper.thermalprocessing.ThermalProcessingMod;
import net.zsemper.thermalprocessing.procedures.IOAutoOutputProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonBackProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonBottomProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonLeftProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonResetProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonRightProcedure;
import net.zsemper.thermalprocessing.procedures.IOButtonTopProcedure;
import net.zsemper.thermalprocessing.procedures.OpenRecipesProcedure;
import net.zsemper.thermalprocessing.world.inventory.AlloyBlenderGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AlloyBlenderGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public AlloyBlenderGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public AlloyBlenderGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(AlloyBlenderGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(AlloyBlenderGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            AlloyBlenderGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = AlloyBlenderGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            IOButtonTopProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            IOButtonLeftProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            IOButtonRightProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            IOButtonBackProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            IOButtonBottomProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            IOButtonResetProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            IOAutoOutputProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            OpenRecipesProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ThermalProcessingMod.addNetworkMessage(AlloyBlenderGUIButtonMessage.class, AlloyBlenderGUIButtonMessage::buffer, AlloyBlenderGUIButtonMessage::new, AlloyBlenderGUIButtonMessage::handler);
    }
}

