/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.RLE;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record PacketReturnShapeData(ShapeID shapeID, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) implements CustomPacketPayload
{
    public static ResourceLocation ID = new ResourceLocation("rftoolsbuilder", "returnshapedata");

    public void write(FriendlyByteBuf buf) {
        this.shapeID.toBytes(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.offsetY);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.msg);
        buf.m_130064_(this.dimension);
        if (this.statePalette == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.statePalette.getPalette().size());
            for (BlockState state : this.statePalette.getPalette()) {
                BlockState blockState = state;
                if (Tools.getId((BlockState)blockState) == null) {
                    blockState = Blocks.f_50069_.m_49966_();
                }
                buf.m_130070_(Tools.getId((BlockState)blockState).toString());
            }
        }
        if (this.positions == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.positions.getData().length);
            buf.writeBytes(this.positions.getData());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketReturnShapeData create(FriendlyByteBuf buf) {
        RLE positions;
        StatePalette statePalette;
        ShapeID shapeID = new ShapeID(buf);
        int count = buf.readInt();
        int offsetY = buf.readInt();
        String msg = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        BlockPos dimension = buf.m_130135_();
        int size = buf.readInt();
        if (size == 0) {
            statePalette = null;
        } else {
            statePalette = new StatePalette();
            while (size > 0) {
                String r = buf.m_130136_(Short.MAX_VALUE);
                Block block = Tools.getBlock((ResourceLocation)new ResourceLocation(r));
                statePalette.add(block.m_49966_());
                --size;
            }
        }
        size = buf.readInt();
        if (size == 0) {
            positions = null;
        } else {
            positions = new RLE();
            byte[] data = new byte[size];
            buf.readBytes(data);
            positions.setData(data);
        }
        return new PacketReturnShapeData(shapeID, positions, statePalette, dimension, count, offsetY, msg);
    }

    public static PacketReturnShapeData create(ShapeID id, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) {
        return new PacketReturnShapeData(id, positions, statePalette, dimension, count, offsetY, msg);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            int dx = this.dimension.m_123341_();
            int dy = this.dimension.m_123342_();
            int dz = this.dimension.m_123343_();
            RLE rle = this.positions;
            RenderData.RenderPlane plane = null;
            if (rle != null) {
                BlockState dummy = ((SupportBlock)BuilderModule.SUPPORT.get()).m_49966_();
                rle.reset();
                int oy = this.offsetY;
                int y = oy - dy / 2;
                RenderData.RenderStrip[] strips = new RenderData.RenderStrip[dx];
                for (int ox = 0; ox < dx; ++ox) {
                    RenderData.RenderStrip strip;
                    int x = ox - dx / 2;
                    strips[ox] = strip = new RenderData.RenderStrip(x);
                    for (int oz = 0; oz < dz; ++oz) {
                        int data = rle.read();
                        if (data < 255) {
                            if (data == 0) {
                                strip.add(dummy);
                                continue;
                            }
                            strip.add(this.statePalette.getPalette().get(--data));
                            continue;
                        }
                        strip.add(null);
                    }
                    strip.close();
                    plane = new RenderData.RenderPlane(strips, y, oy, -dz / 2, this.count);
                }
            }
            ShapeRenderer.setRenderData(this.shapeID, plane, this.offsetY, dy, this.msg);
        });
    }
}

