/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.render.page;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.page.BookMultiblockPage;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.button.VisualizeButton;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.BookPageRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageWithTextRenderer;
import com.klikli_dev.modonomicon.platform.ClientServices;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class BookMultiblockPageRenderer
extends BookPageRenderer<BookMultiblockPage>
implements PageWithTextRenderer {
    private static final RandomSource randomSource = RandomSource.m_216343_();
    private final Map<BlockPos, BlockEntity> blockEntityCache = new Object2ObjectOpenHashMap();
    private final Set<BlockEntity> erroredBlockEntities = Collections.newSetFromMap(new WeakHashMap());
    protected Pair<BlockPos, Collection<Multiblock.SimulateResult>> multiblockSimulation;
    protected Button visualizeButton;

    public BookMultiblockPageRenderer(BookMultiblockPage page) {
        super(page);
    }

    public void handleButtonVisualize(Button button) {
        MultiblockPreviewRenderer.setMultiblock(((BookMultiblockPage)this.page).getMultiblock(), ((BookMultiblockPage)this.page).getMultiblockName().getComponent(), true);
        this.parentScreen.simulateEscClosing = true;
        this.parentScreen.m_7379_();
    }

    private void renderMultiblock(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos pos = BlockPos.f_121853_;
        Rotation facingRotation = Rotation.NONE;
        ((BookMultiblockPage)this.page).getMultiblock().setLevel((Level)level);
        if (((BookMultiblockPage)this.page).getMultiblock().isSymmetrical()) {
            facingRotation = Rotation.NONE;
        }
        Vec3i size = ((BookMultiblockPage)this.page).getMultiblock().getSize();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 62;
        int yPos = 60;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)xPos, (float)yPos, 100.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280168_().m_252880_(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        rotMat.rotate((Quaternionfc)Axis.f_252529_.m_252977_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parentScreen.ticksInBook * 0.5f;
        if (!Screen.m_96638_()) {
            time += ClientTicks.partialTicks;
        }
        guiGraphics.m_280168_().m_252880_(-offX, 0.0f, -offZ);
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(time));
        rotMat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-time));
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(45.0f));
        rotMat.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        guiGraphics.m_280168_().m_252880_(offX, 0.0f, offZ);
        rotMat.transform(eye);
        eye.div(eye.w);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        BlockPos checkPos = null;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockRes = (BlockHitResult)hitResult;
            checkPos = blockRes.m_82425_().m_121945_(blockRes.m_82434_());
        }
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -1.0f);
        for (Multiblock.SimulateResult r : (Collection)this.multiblockSimulation.getSecond()) {
            float alpha = 0.3f;
            if (r.getWorldPosition().equals((Object)checkPos)) {
                alpha = 0.6f + (float)(Math.sin(ClientTicks.total * 0.3f) + 1.0) * 0.1f;
            }
            BlockState renderState = r.getStateMatcher().getDisplayedState(ClientTicks.ticks).m_60717_(facingRotation);
            this.renderBlock(buffers, level, renderState, r.getWorldPosition(), alpha, guiGraphics.m_280168_());
            Block block = renderState.m_60734_();
            if (!(block instanceof EntityBlock)) continue;
            EntityBlock eb = (EntityBlock)block;
            BlockEntity be = this.blockEntityCache.computeIfAbsent(r.getWorldPosition().m_7949_(), p -> eb.m_142194_(p, renderState));
            if (be == null || this.erroredBlockEntities.contains(be)) continue;
            be.m_142339_((Level)mc.f_91073_);
            be.m_155250_(renderState);
            guiGraphics.m_280168_().m_85836_();
            BlockPos bePos = r.getWorldPosition();
            guiGraphics.m_280168_().m_252880_((float)bePos.m_123341_(), (float)bePos.m_123342_(), (float)bePos.m_123343_());
            try {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(be);
                if (renderer != null) {
                    renderer.m_6922_(be, ClientTicks.partialTicks, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
                }
            }
            catch (Exception e) {
                this.erroredBlockEntities.add(be);
                Modonomicon.LOG.error("Error rendering block entity", (Throwable)e);
            }
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85849_();
        buffers.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderBlock(MultiBufferSource.BufferSource buffers, ClientLevel level, BlockState state, BlockPos pos, float alpha, PoseStack ps) {
        if (pos != null) {
            ps.m_85836_();
            ps.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            ClientServices.MULTIBLOCK.renderBlock(state, pos, ((BookMultiblockPage)this.page).getMultiblock(), ps, (MultiBufferSource)buffers, randomSource);
            ps.m_85849_();
        }
    }

    @Override
    public int getTextY() {
        return 115;
    }

    @Override
    public void onBeginDisplayPage(BookContentScreen parentScreen, int left, int top) {
        super.onBeginDisplayPage(parentScreen, left, top);
        this.multiblockSimulation = ((BookMultiblockPage)this.page).getMultiblock().simulate(null, BlockPos.f_121853_, Rotation.NONE, true, true);
        if (((BookMultiblockPage)this.page).showVisualizeButton()) {
            this.visualizeButton = new VisualizeButton(this.parentScreen, 13, 102, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        int x = 9;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookContentScreen.drawFromTexture(guiGraphics, ((BookMultiblockPage)this.page).getBook(), x, y, 405, 149, 106, 106);
        if (!((BookMultiblockPage)this.page).getMultiblockName().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookMultiblockPage)this.page).getMultiblockName(), false, 62, 0);
        }
        this.renderMultiblock(guiGraphics);
        this.renderBookTextHolder(guiGraphics, ((BookMultiblockPage)this.page).getText(), 0, this.getTextY(), 124);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        if (pMouseX > 0.0 && pMouseY > 0.0) {
            Style multiblockNameStyle = this.getClickedComponentStyleAtForTitle(((BookMultiblockPage)this.page).getMultiblockName(), 62, 0, pMouseX, pMouseY);
            if (multiblockNameStyle != null) {
                return multiblockNameStyle;
            }
            Style textStyle = this.getClickedComponentStyleAtForTextHolder(((BookMultiblockPage)this.page).getText(), 0, this.getTextY(), 124, pMouseX, pMouseY);
            if (textStyle != null) {
                return textStyle;
            }
        }
        return super.getClickedComponentStyleAt(pMouseX, pMouseY);
    }
}

