/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.error.BookErrorHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorInfo;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class BookErrorScreen
extends Screen {
    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    private static final ResourceLocation BOOK_CONTENT_TEXTURE = new ResourceLocation("modonomicon", "textures/gui/book_content.png");
    private final Book book;
    private int bookLeft;
    private int bookTop;
    private Component errorText;

    public BookErrorScreen(Book book) {
        super((Component)Component.m_237113_((String)""));
        this.book = book;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void renderBookBackground(GuiGraphics guiGraphics) {
        int x = 0;
        int y = 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(BOOK_CONTENT_TEXTURE, x, y, 0.0f, 0.0f, 272, 178, 512, 256);
    }

    public void renderError(GuiGraphics guiGraphics, Component text, int x, int y, int width) {
        for (FormattedCharSequence formattedcharsequence : this.f_96547_.m_92923_((FormattedText)text, width)) {
            guiGraphics.m_280649_(this.f_96547_, formattedcharsequence, x, y, 0, false);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
    }

    public void prepareError() {
        BookErrorHolder errorHolder = BookErrorManager.get().getErrors(this.book.getId());
        if (errorHolder.getErrors().isEmpty()) {
            this.errorText = Component.m_237115_((String)"modonomicon.gui.no_errors_found");
            Modonomicon.LOG.warn("No errors found for book {}, but error screen was opened!", (Object)this.book.getId());
        } else {
            BookErrorInfo firstError = errorHolder.getErrors().get(0);
            Object errorString = firstError.toString();
            if (errorHolder.getErrors().size() > 1) {
                errorString = (String)errorString + "\n\n(" + (errorHolder.getErrors().size() - 1) + " more errors, see log)";
            }
            this.errorText = Component.m_237113_((String)errorString);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderBookBackground(guiGraphics);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderError(guiGraphics, this.errorText, 15, 15, 242);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6913_() {
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookLeft = (this.f_96543_ - 272) / 2;
        this.bookTop = (this.f_96544_ - 178) / 2;
        this.prepareError();
    }
}

