/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;

public class TugRouteNode {
    private static final String NAME_TAG = "name";
    private static final String X_TAG = "x";
    private static final String Z_TAG = "z";
    private static final String COORDS_TAG = "coordinates";
    private String name;
    private final double x;
    private final double z;

    public TugRouteNode(String name, double x, double z) {
        this.name = name;
        this.x = x;
        this.z = z;
    }

    public TugRouteNode(double x, double y) {
        this(null, x, y);
    }

    public String getDisplayName(int index) {
        if (!this.hasCustomName()) {
            return I18n.m_118938_((String)"item.littlelogistics.tug_route.node", (Object[])new Object[]{index});
        }
        return I18n.m_118938_((String)"item.littlelogistics.tug_route.node_named", (Object[])new Object[]{index, this.getName()});
    }

    public String getDisplayCoords() {
        return this.x + ", " + this.z;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TugRouteNode that = (TugRouteNode)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.z, this.z) == 0 && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.x, this.z);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.hasCustomName()) {
            tag.m_128359_(NAME_TAG, this.getName());
        }
        CompoundTag coords = new CompoundTag();
        coords.m_128347_(X_TAG, this.x);
        coords.m_128347_(Z_TAG, this.z);
        tag.m_128365_(COORDS_TAG, (Tag)coords);
        return tag;
    }

    public static TugRouteNode fromNBT(CompoundTag tag) {
        String name = null;
        if (tag.m_128441_(NAME_TAG)) {
            name = tag.m_128461_(NAME_TAG);
        }
        CompoundTag coords = tag.m_128469_(COORDS_TAG);
        double x = coords.m_128459_(X_TAG);
        double z = coords.m_128459_(Z_TAG);
        return new TugRouteNode(name, x, z);
    }

    public static TugRouteNode fromVector2f(Vec2 node) {
        double x = node.f_82470_;
        double z = node.f_82471_;
        return new TugRouteNode(null, x, z);
    }
}

