/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.render.barge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.murad.shipping.entity.custom.vessel.barge.FluidTankBargeEntity;
import dev.murad.shipping.entity.render.ModelPack;
import dev.murad.shipping.entity.render.barge.MultipartVesselRenderer;
import dev.murad.shipping.util.FluidRenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidTankBargeRenderer<T extends FluidTankBargeEntity>
extends MultipartVesselRenderer<T> {
    protected FluidTankBargeRenderer(EntityRendererProvider.Context context, ModelPack<T> baseModelPack, ModelPack<T> insertModelPack, ModelPack<T> trimModelPack) {
        super(context, baseModelPack, insertModelPack, trimModelPack);
    }

    @Override
    public void render(@NotNull T entity, float yaw, float partialTick, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        super.render(entity, yaw, partialTick, matrixStack, buffer, packedLight);
        this.renderFluid((FluidTankBargeEntity)entity, yaw, partialTick, matrixStack, buffer, 0, packedLight);
    }

    public void renderFluid(FluidTankBargeEntity entity, float yaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluid = entity.getFluidStack();
        if (fluid == null) {
            return;
        }
        Fluid renderFluid = fluid.getFluid();
        if (renderFluid == null) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        matrixStackIn.m_85837_(-0.3, 0.4, -0.25);
        matrixStackIn.m_85841_(1.0f, 1.2f, 1.0f);
        FluidRenderUtil.renderCubeUsingQuads(FluidTankBargeEntity.CAPACITY, fluid, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
    }

    public static class Builder<T extends FluidTankBargeEntity>
    extends MultipartVesselRenderer.Builder<T> {
        public Builder(EntityRendererProvider.Context context) {
            super(context);
        }

        @Override
        public FluidTankBargeRenderer<T> build() {
            return new FluidTankBargeRenderer(this.context, this.baseModelPack, this.insertModelPack, this.trimModelPack);
        }
    }
}

