/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity> {
    private EntityRendererMixin() {
        throw new IllegalAccessError("Attempted to instantiate a Mixin Class!");
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void celestisynth$render(T pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            CSEntityCapabilityProvider.get(living).ifPresent(data -> {
                if (data.getPhantomTagSource() != null) {
                    EntityRendererMixin.renderPhantomFlame(pPoseStack, pBuffer, pEntity);
                }
            });
        }
    }

    private static void renderPhantomFlame(PoseStack pMatrixStack, MultiBufferSource pBuffer, Entity pEntity) {
        TextureAtlasSprite fireSprite0 = ModelBakery.f_119219_.m_119204_();
        TextureAtlasSprite fireSprite1 = ModelBakery.f_119220_.m_119204_();
        pMatrixStack.m_85836_();
        float offsetBBWidth = pEntity.m_20205_() * 1.4f;
        pMatrixStack.m_85841_(offsetBBWidth, offsetBBWidth, offsetBBWidth);
        float xFireVertex = 0.5f;
        float offsetBBHeight = pEntity.m_20206_() / offsetBBWidth;
        float yFireVertexOffset = 0.0f;
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90590_()));
        pMatrixStack.m_85837_(0.0, 0.0, (double)(-0.3f + offsetBBHeight * 0.02f));
        float zFireVertex = 0.0f;
        int stackIdx = 0;
        VertexConsumer blockVc = pBuffer.m_6299_(RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_));
        PoseStack.Pose lastPose = pMatrixStack.m_85850_();
        while (offsetBBHeight > 0.0f) {
            TextureAtlasSprite curFireSprite = stackIdx % 2 == 0 ? fireSprite0 : fireSprite1;
            float curFireSpriteU0 = curFireSprite.m_118409_();
            float curFireSpriteV0 = curFireSprite.m_118411_();
            float curFireSpriteU1 = curFireSprite.m_118410_();
            float curFireSpriteV1 = curFireSprite.m_118412_();
            if (stackIdx / 2 % 2 == 0) {
                float cachedU1 = curFireSpriteU1;
                curFireSpriteU1 = curFireSpriteU0;
                curFireSpriteU0 = cachedU1;
            }
            EntityRendererMixin.fireVertex(lastPose, blockVc, xFireVertex - 0.0f, 0.0f - yFireVertexOffset, zFireVertex, curFireSpriteU1, curFireSpriteV1);
            EntityRendererMixin.fireVertex(lastPose, blockVc, -xFireVertex - 0.0f, 0.0f - yFireVertexOffset, zFireVertex, curFireSpriteU0, curFireSpriteV1);
            EntityRendererMixin.fireVertex(lastPose, blockVc, -xFireVertex - 0.0f, 1.4f - yFireVertexOffset, zFireVertex, curFireSpriteU0, curFireSpriteV0);
            EntityRendererMixin.fireVertex(lastPose, blockVc, xFireVertex - 0.0f, 1.4f - yFireVertexOffset, zFireVertex, curFireSpriteU1, curFireSpriteV0);
            offsetBBHeight -= 0.45f;
            yFireVertexOffset -= 0.45f;
            xFireVertex *= 0.9f;
            zFireVertex += 0.03f;
            ++stackIdx;
        }
        pMatrixStack.m_85849_();
    }

    private static void fireVertex(PoseStack.Pose pMatrixEntry, VertexConsumer pBuffer, float pX, float pY, float pZ, float pTexU, float pTexV) {
        pBuffer.m_252986_(pMatrixEntry.m_252922_(), pX, pY, pZ).m_6122_(0, 20, 0, 70).m_7421_(pTexU, pTexV).m_7122_(0, 10).m_85969_(240).m_252939_(pMatrixEntry.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

