/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.network.c2s;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryManager;
import org.thecelestialworkshop.celestisynth.Celestisynth;
import org.thecelestialworkshop.celestisynth.api.animation.player.AnimationManager;
import org.thecelestialworkshop.celestisynth.api.animation.player.CSAnimator;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;

public class UpdateAnimationToAllPacket {
    private final int layerIndex;
    private final int playerId;
    private final ResourceLocation animId;

    public UpdateAnimationToAllPacket(int layerIndex, int playerId, ResourceLocation animId) {
        this.layerIndex = layerIndex;
        this.playerId = playerId;
        this.animId = animId;
    }

    public UpdateAnimationToAllPacket(FriendlyByteBuf buf) {
        this.layerIndex = buf.readInt();
        this.playerId = buf.readInt();
        this.animId = buf.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.layerIndex);
        buf.writeInt(this.playerId);
        buf.m_130085_(this.animId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft instance = Minecraft.m_91087_();
            Entity player = instance.f_91073_.m_6815_(this.playerId);
            UpdateAnimationToAllPacket.animatePlayer(this.layerIndex, this.animId, (AbstractClientPlayer)player);
        });
        return true;
    }

    public static void animatePlayer(int layerIndex, ResourceLocation animId, AbstractClientPlayer player) {
        ModifierLayer<IAnimation> layer = switch (layerIndex) {
            case 0 -> CSAnimator.animationData.get(player);
            case 1 -> CSAnimator.otherAnimationData.get(player);
            case 2 -> CSAnimator.mirroredAnimationData.get(player);
            default -> throw new IllegalStateException("Invalid layer index!");
        };
        if (layer != null) {
            PlayerAnimationContainer animation = (PlayerAnimationContainer)RegistryManager.ACTIVE.getRegistry(CSPlayerAnimations.ANIMATIONS_KEY).getValue(animId);
            if (animation == null) {
                Celestisynth.LOGGER.warn("Failed to capture animation for server sync: " + animId);
            }
            if (layerIndex == 0) {
                AnimationManager.playAnimation(null, CSAnimator.mirroredAnimationData.get(player));
            }
            if (layerIndex == 2) {
                AnimationManager.playAnimation(null, CSAnimator.animationData.get(player));
            }
            AnimationManager.playAnimation(animation == null || animation == CSPlayerAnimations.CLEAR.get() ? null : animation.asAnimation(), layer);
        }
    }
}

