/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.item.weapons;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.thecelestialworkshop.celestisynth.api.animation.player.AnimationManager;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.CSGeoItem;
import org.thecelestialworkshop.celestisynth.api.item.CSWeapon;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import org.thecelestialworkshop.celestisynth.common.compat.apotheosis.CSCompatAP;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualAnimation;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.entity.mob.misc.RainfallTurret;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.RainfallArrow;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.manager.CSIntegrationManager;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class RainfallSerenityItem
extends BowItem
implements CSWeapon,
CSGeoItem {
    public static CSVisualAnimation SPECIAL_RAINFALL = new CSVisualAnimation("animation.cs_effect.special_rainfall", 50);
    public static final String PULL = "cs.pull";
    public static final String PULLING = "cs.pulling";

    public RainfallSerenityItem(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "rainfall_serenity";
    }

    @Override
    public String texture(ItemStack stack) {
        float pull = this.attackExtras(stack).m_128457_(PULL);
        float pulling = this.attackExtras(stack).m_128457_(PULLING);
        if (pulling == 1.0f && pull >= 1.0f) {
            return "rainfall_serenity_pulling_2";
        }
        if (pulling == 1.0f && (double)pull >= 0.5) {
            return "rainfall_serenity_pulling_1";
        }
        if (pulling >= 1.0f) {
            return "rainfall_serenity_pulling_0";
        }
        return "rainfall_serenity";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public int getPassiveAmount() {
        return 0;
    }

    @Override
    public int getSkillsAmount() {
        return 4;
    }

    public void addExtraAttributes(ImmutableMultimap.Builder<Attribute, AttributeModifier> map) {
        if (CSIntegrationManager.checkIronsSpellbooks()) {
            map.put((Object)((Attribute)AttributeRegistry.SPELL_POWER.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item spell power", 0.075, AttributeModifier.Operation.MULTIPLY_BASE));
            map.put((Object)((Attribute)AttributeRegistry.MANA_REGEN.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item mana regen", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int useDuration) {
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        CompoundTag elementData = heldStack.m_41698_("csController");
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)heldStack, (Level)pLevel, (Player)pPlayer, (InteractionHand)pHand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        if (!pPlayer.m_6144_()) {
            pPlayer.m_6672_(pHand);
            elementData.m_128379_("cs.hasAnimationBegun", true);
            if (pHand == InteractionHand.MAIN_HAND) {
                AnimationManager.playAnimation(pLevel, (PlayerAnimationContainer)CSPlayerAnimations.ANIM_RAINFALL_AIM_RIGHT.get());
            } else {
                AnimationManager.playAnimation(pLevel, (PlayerAnimationContainer)CSPlayerAnimations.ANIM_RAINFALL_AIM_LEFT.get());
            }
            return InteractionResultHolder.m_19096_((Object)heldStack);
        }
        if (!pPlayer.m_36335_().m_41519_((Item)this)) {
            this.shiftSkill(pLevel, pPlayer);
            pPlayer.m_36335_().m_41524_((Item)this, 200);
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        return InteractionResultHolder.m_19100_((Object)heldStack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            if (living.m_21211_() != pStack) {
                this.attackExtras(pStack).m_128350_(PULL, 0.0f);
                this.attackExtras(pStack).m_128350_(PULLING, 0.0f);
            } else {
                this.attackExtras(pStack).m_128350_(PULL, (float)(pStack.m_41779_() - living.m_21212_()) / ((RainfallSerenityItem)pStack.m_41720_()).getDrawSpeed(living, pStack));
                this.attackExtras(pStack).m_128350_(PULLING, 1.0f);
            }
        }
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        pLivingEntity.m_5618_(pLivingEntity.m_146908_());
    }

    public void shiftSkill(Level level, Player player) {
        CSEffectEntity.createInstance((LivingEntity)player, null, (CSVisualType)CSVisualTypes.RAINFALL_VANISH.get(), this.calculateXLook((LivingEntity)player) * 3.0, 1.0, this.calculateZLook((LivingEntity)player) * 3.0);
        CSEffectEntity.createInstance((LivingEntity)player, null, (CSVisualType)CSVisualTypes.RAINFALL_VANISH_CIRCLE.get(), 0.0, -1.5, 0.0);
        player.m_216990_((SoundEvent)CSSoundEvents.VANISH.get());
        player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19596_, 100, 3));
        player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19609_, 100, 0));
        CSEntityCapabilityProvider.get((LivingEntity)player).ifPresent(data -> data.setTrueInvisibility(100));
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (Mob mob : StreamSupport.stream(server.m_8583_().spliterator(), false).filter(e -> e instanceof Mob).map(Mob.class::cast).filter(m -> m.m_5448_() == player).toList()) {
                mob.m_6710_(null);
            }
        }
    }

    public void release(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft, Player player, float charge, ArrowItem arrowitem, ItemStack projectileStack, AbstractArrow existingArrow) {
        int mult = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)pStack);
        if (mult > 0) {
            for (int i = 1; i < mult + 1; ++i) {
                this.createAndShootArrow(pLevel, player, charge, existingArrow, arrowitem, projectileStack, 15.0f * (float)i);
                this.createAndShootArrow(pLevel, player, charge, existingArrow, arrowitem, projectileStack, -15.0f * (float)i);
            }
        }
    }

    private void createAndShootArrow(Level pLevel, Player player, float charge, AbstractArrow existingArrow, ArrowItem arrowitem, ItemStack projectileStack, float yOffset) {
        AbstractArrow clone = arrowitem.m_6394_(pLevel, projectileStack, (LivingEntity)player);
        clone = this.customArrow(clone);
        this.transferPropertiesToClone(existingArrow, clone);
        Vec3 vec31 = player.m_20289_(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yOffset * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
        Vec3 vec3 = player.m_20252_(1.0f);
        Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
        clone.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), charge * 3.0f, 1.0f);
        clone.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        pLevel.m_7967_((Entity)clone);
    }

    public void transferPropertiesToClone(AbstractArrow existingArrow, AbstractArrow clone) {
        for (Class<?> existingArrowClass = existingArrow.getClass(); existingArrowClass != null; existingArrowClass = existingArrowClass.getSuperclass()) {
            for (Field field : existingArrowClass.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    if (!Modifier.isPublic(field.getModifiers()) && !field.getName().equals("remainingFireTicks")) continue;
                    field.set(clone, field.get(existingArrow));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        CompoundTag compoundTag = new CompoundTag();
        existingArrow.m_7380_(compoundTag);
        clone.m_7378_(compoundTag);
    }

    public void releaseUsingEffect(ItemStack pStack, Level pLevel, LivingEntity player, int pTimeLeft) {
        CompoundTag elementData = pStack.m_41698_("csController");
        int useDuration = this.m_8105_(pStack) - pTimeLeft;
        double curPowerFromUse = RainfallSerenityItem.getPowerForTime(player, pStack, useDuration);
        AnimationManager.playAnimation(pLevel, (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get());
        elementData.m_128379_("cs.hasAnimationBegun", false);
        if (curPowerFromUse >= 1.0) {
            if (curPowerFromUse == 1.0) {
                CSEffectEntity.createInstance(player, null, (CSVisualType)CSVisualTypes.RAINFALL_SHOOT.get(), this.calculateXLook(player) * 2.0, 0.5 + this.calculateYLook(player, 5.0) * 1.0, this.calculateZLook(player) * 2.0);
                player.m_20256_(player.m_20184_().m_82492_(this.calculateXLook(player) * 0.5, 0.0, this.calculateZLook(player) * 0.5));
            }
            int amount = 50;
            float expansionMultiplier = 0.5f;
            for (int e = 0; e < amount; ++e) {
                RandomSource random = player.m_217043_();
                double angle = random.m_188500_() * 2.0 * Math.PI;
                float offX = (float)Math.cos(angle) * expansionMultiplier;
                float offY = (-0.5f + random.m_188501_()) * expansionMultiplier;
                float offZ = (float)Math.sin(angle) * expansionMultiplier;
                ParticleUtil.sendParticles(pLevel, (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0, (double)offX, (double)offY, (double)offZ);
            }
        }
        pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)CSSoundEvents.LASER_SHOOT.get(), SoundSource.PLAYERS, (float)((double)0.7f * curPowerFromUse), (float)((double)(1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f)) + curPowerFromUse * 0.5));
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        this.releaseUsingEffect(pStack, pLevel, pEntityLiving, pTimeLeft);
        super.m_5551_(pStack, pLevel, pEntityLiving, pTimeLeft);
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        Entity entity;
        RainfallArrow rainfallArrow = new RainfallArrow(arrow);
        rainfallArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        rainfallArrow.setOrigin(arrow.m_19749_().m_20182_());
        rainfallArrow.m_36767_((byte)3);
        rainfallArrow.setImbueQuasar(true);
        rainfallArrow.setStrong(true);
        if (CSIntegrationManager.checkApothicAttributes() && (entity = arrow.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            rainfallArrow.m_36781_(rainfallArrow.m_36789_() + 3.0 + (double)CSCompatAP.apothValue((RegistryObject<Attribute>)ALObjects.Attributes.ARROW_VELOCITY, owner));
        }
        return rainfallArrow;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Entity owner = entity.m_9236_().m_6815_(this.attackExtras(stack).m_128451_("ownerRF"));
        if (entity.m_20096_() && owner != null && stack.m_41773_() < stack.m_41776_() - 1) {
            entity.m_216990_(SoundEvents.f_11897_);
            if (!entity.m_9236_().f_46443_ && owner instanceof Player) {
                Player player = (Player)owner;
                RainfallTurret turret = (RainfallTurret)((EntityType)CSEntityTypes.RAINFALL_TURRET.get()).m_20615_(entity.m_9236_());
                turret.m_20219_(entity.m_20182_());
                turret.setOwner(player);
                double healthAdd = turret.m_21233_() + (float)(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack) * 50);
                turret.m_21051_(Attributes.f_22276_).m_22100_(healthAdd);
                turret.m_21153_(turret.m_21233_());
                entity.m_9236_().m_7967_((Entity)turret);
                turret.setItemData(stack.serializeNBT());
                for (int i = 0; i < 16; ++i) {
                    ParticleUtil.sendParticle(entity.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), entity.m_20182_().m_82520_(entity.m_9236_().f_46441_.m_188583_() * 0.4, 0.0, entity.m_9236_().f_46441_.m_188583_() * 0.4), Vec3.f_82478_.m_82520_(0.0, entity.m_9236_().f_46441_.m_188500_() * 0.65, 0.0));
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.attackExtras(stack).m_128405_("ownerRF", player.m_19879_());
        return super.onDroppedByPlayer(stack, player);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        enchantments.add(Enchantments.f_44988_);
        enchantments.add(Enchantments.f_44989_);
        enchantments.add(Enchantments.f_44990_);
        enchantments.add(Enchantments.f_44959_);
        enchantments.add(Enchantments.f_44961_);
        enchantments.add(Enchantments.f_44960_);
        if ((enchantment == Enchantments.f_44959_ || enchantment == Enchantments.f_44960_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack) > 0) {
            return false;
        }
        if (enchantment == Enchantments.f_44961_ && (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack) > 0)) {
            return false;
        }
        if (enchantments.contains(enchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public float getDrawSpeed(LivingEntity entity, ItemStack stack) {
        float piercingEnchLvl = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        float quickEnchLvl = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float apoth_drawSpeed = CSCompatAP.apothRainfallSerenityDrawSpeed(entity);
        return (7.5f + piercingEnchLvl * 10.0f) / ((quickEnchLvl + 1.0f) * 0.6f) + apoth_drawSpeed;
    }

    public static float getPowerForTime(LivingEntity pEntityLiving, ItemStack stack, int pCharge) {
        float totalCharge = (float)pCharge / ((RainfallSerenityItem)stack.m_41720_()).getDrawSpeed(pEntityLiving, stack);
        if ((totalCharge = (totalCharge * totalCharge + totalCharge * 2.0f) / 3.0f) > 1.0f) {
            totalCharge = 1.0f;
        }
        return totalCharge;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.NONE;
    }
}

