/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.item.weapons;

import com.google.common.collect.ImmutableList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.animation.player.AnimationManager;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.CSGeoItem;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.attack.keres.KeresRendAttack;
import org.thecelestialworkshop.celestisynth.common.attack.keres.KeresSlashAttack;
import org.thecelestialworkshop.celestisynth.common.attack.keres.KeresSmashAttack;
import org.thecelestialworkshop.celestisynth.common.compat.bettercombat.SwingParticleContainer;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.KeresShadow;
import org.thecelestialworkshop.celestisynth.common.item.base.SkilledSwordItem;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSMobEffects;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class KeresItem
extends SkilledSwordItem
implements CSGeoItem {
    public static final String PASSIVE_STACK = "cs.keresStack";

    public KeresItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "keres";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int dur) {
        return ImmutableList.of((Object)new KeresSlashAttack(player, stack, dur), (Object)new KeresRendAttack(player, stack, dur), (Object)new KeresSmashAttack(player, stack, dur));
    }

    @Override
    @Nullable
    public SwingParticleContainer getSwingContainer(LivingEntity holder, ItemStack stack) {
        if (holder.m_21023_((MobEffect)CSMobEffects.HELLBANE.get()) && holder.m_217043_().m_188503_(5) == 1) {
            return new SwingParticleContainer((ParticleType)CSParticleTypes.KERES_OMEN.get(), 2.8f);
        }
        return new SwingParticleContainer((ParticleType)CSParticleTypes.KERES_ASH.get(), 2.8f);
    }

    @Override
    public int getSkillsAmount() {
        return 3;
    }

    @Override
    public int getPassiveAmount() {
        return 3;
    }

    @Override
    public void startUsing(Level level, Player player, InteractionHand interactionHand) {
        super.startUsing(level, player, interactionHand);
        int layer = interactionHand == InteractionHand.OFF_HAND ? 0 : 2;
        AnimationManager.playAnimation(level, (PlayerAnimationContainer)CSPlayerAnimations.ANIM_KERES_CHARGE.get(), layer);
    }

    public void m_5929_(Level pLevel, LivingEntity pEntity, ItemStack pStack, int pRemainingUseDuration) {
        Player player;
        int durThreshold;
        super.m_5929_(pLevel, pEntity, pStack, pRemainingUseDuration);
        int dur = this.m_8105_(pStack) - pRemainingUseDuration;
        int n = durThreshold = dur >= 200 ? 15 : 30;
        if (dur % durThreshold == 0) {
            float sacrificeThreshold = 1.0f;
            if (pEntity.m_21223_() - sacrificeThreshold > 0.0f && !this.isCreativeOrSpectator((Entity)pEntity)) {
                pEntity.m_21153_(pEntity.m_21223_() - sacrificeThreshold);
                if (pEntity instanceof Player) {
                    player = (Player)pEntity;
                    player.m_36324_().m_38717_(player.m_36324_().m_38722_() + 1.0f);
                }
                this.sacrificeEffect(pLevel, pEntity, dur);
            } else if (!this.isCreativeOrSpectator((Entity)pEntity)) {
                if (pEntity instanceof Player) {
                    player = (Player)pEntity;
                    player.m_36335_().m_41524_((Item)this, 20);
                    AnimationManager.playAnimation(pLevel, (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get());
                    if (pLevel.f_46443_) {
                        player.m_5661_((Component)Component.m_237115_((String)"item.celestisynth.keres.notice").m_130940_(ChatFormatting.RED), true);
                    }
                }
                pEntity.m_5810_();
            } else {
                this.sacrificeEffect(pLevel, pEntity, dur);
            }
        }
        if (pEntity instanceof Player && (player = (Player)pEntity).m_6144_() && dur < 200) {
            int i = 0;
            while ((double)i < 22.5) {
                ParticleUtil.sendParticle(pLevel, (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), player.m_20185_() + this.calculateXLook((LivingEntity)player) * ((double)dur / 3.0) + (double)(Mth.m_14031_((float)i) * 5.0f), player.m_20186_(), player.m_20189_() + this.calculateZLook((LivingEntity)player) * ((double)dur / 3.0) + (double)(Mth.m_14089_((float)i) * 5.0f), (double)(-Mth.m_14031_((float)i)) * 0.3, 0.5, (double)(-Mth.m_14089_((float)i)) * 0.3);
                ++i;
            }
        }
        if (dur >= 200) {
            if (pEntity instanceof Player) {
                Player player2 = (Player)pEntity;
                this.shakeScreensForNearbyPlayers((Entity)player2, pLevel, 12.0, 30, 15, 0.01f);
            }
            ParticleUtil.sendParticle(pLevel, ParticleTypes.f_123747_, pEntity.m_20185_(), pEntity.m_20186_() + 4.0, pEntity.m_20189_());
        }
    }

    public void sacrificeEffect(Level pLevel, LivingEntity pEntity, int dur) {
        pEntity.m_5496_((SoundEvent)CSSoundEvents.HEARTBEAT.get(), 1.0f, (float)(1.0 + pLevel.f_46441_.m_188583_() * 0.2));
        if (dur > 0) {
            this.pulseImageOnUI((Entity)pEntity, "keres_carnage_" + pLevel.f_46441_.m_188503_(3), 0);
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            player.m_5661_((Component)Component.m_237115_((String)"item.celestisynth.keres.notice1").m_130940_(ChatFormatting.RED), true);
        }
        for (int i = 0; i < 10; ++i) {
            float xr = pLevel.f_46441_.m_188501_();
            float zr = pLevel.f_46441_.m_188501_();
            ParticleUtil.sendParticle(pLevel, ParticleTypes.f_123762_, pEntity.m_20182_().m_82520_((double)xr, 0.0, (double)zr), Vec3.f_82478_.m_82520_(0.0, 0.5 * (double)pLevel.f_46441_.m_188501_(), 0.0));
        }
    }

    public boolean isCreativeOrSpectator(Entity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            return player.m_7500_() || player.m_5833_();
        }
        return false;
    }

    @Override
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        if (isSelected) {
            LivingEntity source;
            if (entity instanceof LivingEntity && (source = (LivingEntity)entity).m_21023_((MobEffect)CSMobEffects.HELLBANE.get())) {
                double xSin = Mth.m_14031_((float)((float)(0.2 * (double)source.f_19797_))) * 3.0f;
                double zCos = Mth.m_14089_((float)((float)(0.2 * (double)source.f_19797_))) * 3.0f;
                ParticleUtil.sendParticle(level, (SimpleParticleType)CSParticleTypes.KERES_ASH.get(), entity.m_20185_() + xSin, entity.m_20186_() + 1.0, entity.m_20189_() + zCos);
                ParticleUtil.sendParticle(level, (SimpleParticleType)CSParticleTypes.KERES_ASH.get(), entity.m_20185_() - xSin, entity.m_20186_() + 1.0, entity.m_20189_() - zCos);
                if (source.f_19797_ % 10 == 0) {
                    if (!level.m_5776_()) {
                        LivingEntity observedLiving;
                        LivingEntity observedLivingTarget;
                        KeresShadow shadow = new KeresShadow((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.KERES_SHADOW.get()), source, level);
                        shadow.m_6027_(source.m_20185_(), shadow.m_20186_() - 1.0, source.m_20189_());
                        Entity lookAtTarget = this.getLookedAtEntity(source, 128.0);
                        LivingEntity livingEntity = observedLivingTarget = lookAtTarget instanceof LivingEntity ? (observedLiving = (LivingEntity)lookAtTarget) : null;
                        if (observedLivingTarget != null) {
                            shadow.setHomingTarget(observedLivingTarget);
                        }
                        shadow.damage = this.calculateAttributeDependentDamage(source, itemStack, 0.2f);
                        shadow.m_37251_((Entity)source, (float)(source.m_217043_().m_188583_() * 180.0), -15.0f - (float)(source.m_217043_().m_188500_() * 75.0), 0.0f, 1.0f, 0.0f);
                        shadow.m_20334_(level.f_46441_.m_188583_() * 0.25, 0.4, level.f_46441_.m_188583_() * 0.25);
                        level.m_7967_((Entity)shadow);
                    }
                    source.m_5496_(SoundEvents.f_12558_, 0.1f, 1.5f + source.m_217043_().m_188501_() * 0.5f);
                }
            }
        } else {
            this.attackController(itemStack).m_128405_(PASSIVE_STACK, 0);
        }
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        boolean flag = super.m_7579_(itemStack, entity, source);
        if (flag) {
            double lifesteal = 0.35;
            if (source.m_21023_((MobEffect)CSMobEffects.HELLBANE.get())) {
                lifesteal = 0.85;
            }
            source.m_5634_((float)lifesteal);
            this.attackController(itemStack).m_128405_(PASSIVE_STACK, this.attackController(itemStack).m_128451_(PASSIVE_STACK) + 1);
            if (this.attackController(itemStack).m_128451_(PASSIVE_STACK) >= 5) {
                if (source instanceof Player) {
                    Player player = (Player)source;
                    player.m_36335_().m_41527_((Item)this);
                }
                source.m_7292_(new MobEffectInstance((MobEffect)CSMobEffects.HELLBANE.get(), 100, 0));
                this.attackController(itemStack).m_128405_(PASSIVE_STACK, 0);
            }
        }
        return flag;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44959_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }
}

