/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.item.weapons;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.item.CSGeoItem;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.attack.frostbound.FrostboundCryogenesisAttack;
import org.thecelestialworkshop.celestisynth.common.attack.frostbound.FrostboundDanceAttack;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import org.thecelestialworkshop.celestisynth.common.compat.bettercombat.SwingParticleContainer;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualAnimation;
import org.thecelestialworkshop.celestisynth.common.entity.helper.skinset.FrostboundSlashSkinSet;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.FrostboundShard;
import org.thecelestialworkshop.celestisynth.common.item.base.SkilledSwordItem;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSItems;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class FrostboundItem
extends SkilledSwordItem
implements CSGeoItem {
    public static CSVisualAnimation SPECIAL_ICE_CAST = new CSVisualAnimation("animation.cs_effect.special_ice_cast", 40);

    public FrostboundItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "frostbound";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int dur) {
        return ImmutableList.of((Object)new FrostboundDanceAttack(player, stack), (Object)new FrostboundCryogenesisAttack(player, stack));
    }

    @Override
    @Nullable
    public SwingParticleContainer getSwingContainer(LivingEntity holder, ItemStack stack) {
        return new SwingParticleContainer((ParticleType<?>)ParticleTypes.f_175821_, 1.5f);
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        CSEntityCapabilityProvider.get(entity).ifPresent(data -> data.setFrostbound(100));
        entity.m_216990_(SoundEvents.f_144205_);
        return super.m_7579_(itemStack, entity, source);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        int dur = this.m_8105_(pStack) - pRemainingUseDuration;
        if (dur % 10 == 0) {
            for (int i = 0; i <= pLevel.f_46441_.m_188503_(2); ++i) {
                if (!(pLivingEntity instanceof Player)) continue;
                Player player = (Player)pLivingEntity;
                double xx = pLevel.f_46441_.m_188583_() * 3.0;
                double yy = pLevel.f_46441_.m_188500_() * 2.0;
                double zz = pLevel.f_46441_.m_188583_() * 3.0;
                this.shootShard(player, pStack, xx, yy, zz);
            }
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public void shootShard(Player player, ItemStack stack, double xx, double yy, double zz) {
        FrostboundSlashSkinSet skinSet = FrostboundSlashSkinSet.of(stack, player);
        FrostboundItem.shootShard(this, stack, player, player.m_9236_(), xx, yy, zz);
        if (FrostboundItem.getShard(player) != ItemStack.f_41583_) {
            float pitch = (float)(player.m_217043_().m_188583_() * 0.5);
            player.m_5496_(skinSet.frozenShardPulseSound(), 0.2f, 1.0f + pitch);
        }
    }

    public static void shootShard(CSWeaponUtil util, ItemStack stack, Player player, Level level, double xx, double yy, double zz) {
        FrostboundSlashSkinSet skinSet = FrostboundSlashSkinSet.of(stack, player);
        ItemStack shardStack = FrostboundItem.getShard(player);
        if (shardStack != ItemStack.f_41583_) {
            int indexLucky;
            Entity entity2;
            LivingEntity target = null;
            List<Entity> list = util.iterateEntities(level, util.createAABB((Vec3i)player.m_20183_().m_7494_(), 36.0)).stream().filter(entity -> entity instanceof LivingEntity && entity != player && player.m_142582_(entity)).toList();
            if (!list.isEmpty() && (entity2 = list.get(indexLucky = level.f_46441_.m_188503_(list.size()))) instanceof LivingEntity) {
                LivingEntity indexLuckyLiving;
                target = indexLuckyLiving = (LivingEntity)entity2;
            }
            if (target != null) {
                FrostboundShard shard = new FrostboundShard((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.FROSTBOUND_SHARD.get()), (LivingEntity)player, level);
                shard.m_6027_(player.m_20185_() + xx, shard.m_20186_() + yy, player.m_20189_() + zz);
                CSEffectEntity.createInstance((LivingEntity)player, null, skinSet.frozenShardPulseEffect(), xx, yy + 3.0, zz);
                double d0 = target.m_20185_() - (player.m_20185_() + xx);
                double d1 = target.m_20227_(0.3333333333333333) - (shard.m_20186_() + yy);
                double d2 = target.m_20189_() - (player.m_20189_() + zz);
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                shard.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 5.0f);
                level.m_7967_((Entity)shard);
                if (!player.m_150110_().f_35937_) {
                    shardStack.m_41774_(1);
                    if (shardStack.m_41619_()) {
                        player.m_150109_().m_36057_(shardStack);
                    }
                }
            }
        }
    }

    public static ItemStack getShard(Player player) {
        Predicate<ItemStack> predicate = p -> p.m_41720_() == CSItems.WINTEREIS_SHARD.get();
        ItemStack fromHandStack = ProjectileWeaponItem.m_43010_((LivingEntity)player, predicate);
        if (!fromHandStack.m_41619_()) {
            return fromHandStack;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack fromInventoryStack = player.m_150109_().m_8020_(i);
            if (!predicate.test(fromInventoryStack)) continue;
            return fromInventoryStack;
        }
        return player.m_150110_().f_35937_ ? new ItemStack((ItemLike)CSItems.WINTEREIS_SHARD.get()) : ItemStack.f_41583_;
    }
}

