/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.events;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.thecelestialworkshop.celestisynth.api.animation.player.AnimationManager;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.CSArmorItem;
import org.thecelestialworkshop.celestisynth.api.item.CSWeapon;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import org.thecelestialworkshop.celestisynth.common.compat.CompatRegistryManager;
import org.thecelestialworkshop.celestisynth.common.entity.mob.natural.Traverser;
import org.thecelestialworkshop.celestisynth.common.entity.projectile.SolarisBomb;
import org.thecelestialworkshop.celestisynth.common.entity.skillcast.SkillCastPoltergeistWard;
import org.thecelestialworkshop.celestisynth.common.item.weapons.BreezebreakerItem;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSMobEffects;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSTags;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;

public class CSCommonMiscEvents {
    @SubscribeEvent
    public static void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        CSEntityCapabilityProvider.get(entity).ifPresent(data -> {
            double offZ;
            double offY;
            double offX;
            double speed;
            double radius;
            if (data.getQuasarImbueSource() != null) {
                radius = 0.5 + (double)entity.m_20205_();
                speed = 0.1;
                offX = radius * Math.sin(speed * (double)entity.f_19797_);
                offY = -Math.sin(entity.f_19797_) * 0.2;
                offZ = radius * Math.cos(speed * (double)entity.f_19797_);
                ParticleUtil.sendParticle(entity.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), entity.m_20185_() + offX, entity.m_20186_() + offY + 1.0, entity.m_20189_() + offZ);
            }
            if (data.getQuasarImbueTime() <= 0) {
                data.clearQuasarImbue();
            } else {
                data.decreaseQuasarImbueTime();
            }
            if (data.getPhantomTagTime() <= 0) {
                data.clearPhantomTag();
            } else {
                data.decreasePhantomTagTime();
            }
            if (data.getTrueInvisibility() > 0) {
                data.decreaseTrueInvisibility();
            }
            if (data.getFrostbound() > 0) {
                if (entity.f_19797_ % 10 == 0) {
                    entity.m_146917_(10);
                }
                entity.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 2, 4));
                entity.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19613_, 2, 1));
                entity.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19599_, 2, 4));
                radius = 0.8 + (double)entity.m_20205_();
                speed = 0.2;
                offX = radius * Math.sin(speed * (double)entity.f_19797_);
                offY = 1.0;
                offZ = radius * Math.cos(speed * (double)entity.f_19797_);
                ParticleUtil.sendParticle(entity.m_9236_(), ParticleTypes.f_175821_, entity.m_20185_() + offX, entity.m_20186_() + offY, entity.m_20189_() + offZ);
                if (entity.m_6095_().m_204039_(CSTags.EntityTypes.FROSTBOUND_SENSITIVE) && entity.f_19797_ % 5 == 0) {
                    entity.m_6469_(entity.m_269291_().m_269109_(), 2.0f);
                }
                if (entity.m_6060_()) {
                    if (entity.f_19797_ % 10 == 0) {
                        entity.m_216990_(SoundEvents.f_11937_);
                    }
                    data.decreaseFrostbound(5);
                } else {
                    data.decreaseFrostbound();
                }
            }
        });
    }

    @SubscribeEvent
    public static void onWeaponCrit(CriticalHitEvent event) {
    }

    @SubscribeEvent
    public static void giveItemAttributes(ItemAttributeModifierEvent event) {
        CompatRegistryManager.manageCompatAttributes(event);
    }

    @SubscribeEvent
    public static void onLivingHealEvent(LivingHealEvent event) {
        if (event.getEntity().m_21023_((MobEffect)CSMobEffects.CURSEBANE.get())) {
            event.setAmount((float)((double)event.getAmount() / (1.0 + (double)event.getEntity().m_21124_((MobEffect)CSMobEffects.CURSEBANE.get()).m_19564_() * 2.4)));
        }
        if (event.getEntity().m_21023_((MobEffect)CSMobEffects.HELLBANE.get())) {
            event.setAmount((float)((double)event.getAmount() * (1.0 + (double)event.getEntity().m_21124_((MobEffect)CSMobEffects.HELLBANE.get()).m_19564_() * 1.6)));
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        entity = event.getEntity();
        itemR = entity.m_21205_();
        itemL = entity.m_21206_();
        var8_4 = itemR.m_41720_();
        if (!(var8_4 instanceof CSWeapon)) ** GOTO lbl-1000
        cs = (CSWeapon)var8_4;
        var8_4 = itemL.m_41720_();
        if (var8_4 instanceof CSWeapon) {
            cs2 = (CSWeapon)var8_4;
            cs.onPlayerHurt(event, itemR);
            cs2.onPlayerHurt(event, itemL);
        } else if ((var8_4 = itemR.m_41720_()) instanceof CSWeapon) {
            cs = (CSWeapon)var8_4;
            cs.onPlayerHurt(event, itemR);
        } else {
            var8_4 = itemL.m_41720_();
            if (var8_4 instanceof CSWeapon) {
                cs = (CSWeapon)var8_4;
                cs.onPlayerHurt(event, itemR);
            }
        }
        CSArmorItem.hurtWearer(event);
        SolarisBomb.handleHurtEvent(event);
    }

    @SubscribeEvent
    public static void onLivingCritEvent(CriticalHitEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof Traverser) {
            Traverser traverser = (Traverser)entity;
            if (event.isVanillaCritical()) {
                traverser.resetAnimationTick();
                traverser.setAction(5);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CSWeaponUtil.disableRunningWeapon((Entity)player);
        }
        CSEntityCapabilityProvider.get(event.getEntity()).ifPresent(data -> {
            LivingEntity patt7532$temp = data.getPhantomTagSource();
            if (patt7532$temp instanceof Player) {
                Player player = (Player)patt7532$temp;
                SkillCastPoltergeistWard poltergeistProjectile = (SkillCastPoltergeistWard)((EntityType)CSEntityTypes.POLTERGEIST_WARD.get()).m_20615_(event.getEntity().m_9236_());
                poltergeistProjectile.setOwnerUUID(player.m_20148_());
                poltergeistProjectile.m_6027_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_());
                event.getEntity().m_9236_().m_7967_((Entity)poltergeistProjectile);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerCopy(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            CSWeaponUtil.disableRunningWeapon((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLivingFallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Item itemR = entity.m_21205_().m_41720_();
        Item itemL = entity.m_21206_().m_41720_();
        if (entity instanceof Player && (player = (Player)entity).m_9236_().m_5776_()) {
            AnimationManager.playAnimation((PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get(), 1);
        }
        if (itemR instanceof BreezebreakerItem || itemL instanceof BreezebreakerItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        Item itemR = entity.m_21205_().m_41720_();
        Item itemL = entity.m_21206_().m_41720_();
        if ((itemR instanceof BreezebreakerItem || itemL instanceof BreezebreakerItem) && entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_5776_()) {
                AnimationManager.playAnimation((PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_JUMP.get(), 1);
            }
            player.m_216990_((SoundEvent)CSSoundEvents.HOP.get());
            if (itemR instanceof CSWeapon) {
                CSWeapon wp = (CSWeapon)itemR;
                wp.sendExpandingParticles(entity.m_9236_(), (ParticleType<?>)ParticleTypes.f_123762_, player.m_20183_(), 75, 0.35f);
            } else {
                CSWeapon wp = (CSWeapon)itemL;
                wp.sendExpandingParticles(entity.m_9236_(), (ParticleType<?>)ParticleTypes.f_123762_, player.m_20183_(), 75, 0.35f);
            }
            player.m_20256_(entity.m_20184_().m_82542_(2.75, 2.25, 2.75));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Inventory inv = event.getEntity().m_150109_();
        ObjectArrayList invCompartments = Streams.concat((Stream[])new Stream[]{inv.f_35974_.stream(), inv.f_35975_.stream(), inv.f_35976_.stream()}).collect(Collectors.toCollection(ObjectArrayList::new));
        for (ItemStack stack : invCompartments) {
            if (stack.m_41619_() || stack.m_41737_("csController") == null) continue;
            stack.m_41783_().m_128473_("csController");
        }
    }
}

