/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.projectile;

import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.api.item.AttackHurtTypes;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;

public class SolarisBomb
extends ThrowableProjectile
implements CSWeaponUtil {
    private static final EntityDataAccessor<Integer> LOOSE_TARGET = SynchedEntityData.m_135353_(SolarisBomb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SolarisBomb(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SolarisBomb(EntityType<? extends ThrowableProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public SolarisBomb(EntityType<? extends ThrowableProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_19749_() != null) {
            List<Projectile> projectiles;
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.f_19796_.m_188583_() * 0.05, this.f_19796_.m_188583_() * 0.05, this.f_19796_.m_188583_() * 0.05);
            if (this.getLooseTarget() == null) {
                double plX = this.m_19749_().m_20185_() - (double)(Mth.m_14031_((float)((float)this.f_19797_ / 8.0f)) * 7.0f);
                double plY = this.m_19749_().m_20186_() + (double)Mth.m_14031_((float)((float)this.f_19797_ / 4.0f)) * 0.5;
                double plZ = this.m_19749_().m_20189_() - (double)(Mth.m_14089_((float)((float)this.f_19797_ / 8.0f)) * 7.0f);
                Vec3 plPos = new Vec3(plX, plY + 1.0, plZ);
                this.m_20256_(plPos.m_82546_(this.m_20182_()).m_82490_((double)0.1f));
            }
            if (!(projectiles = this.m_9236_().m_45976_(Projectile.class, this.m_20191_()).stream().filter(projectile -> projectile.m_19749_() != this.m_19749_()).toList()).isEmpty()) {
                for (Projectile targets : projectiles) {
                    targets.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.explodeFire();
                }
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public static Stream<SolarisBomb> getAllBombsOwnedBy(LivingEntity owner, ServerLevel level) {
        return StreamSupport.stream(level.m_8583_().spliterator(), false).filter(mob -> mob instanceof SolarisBomb).map(SolarisBomb.class::cast).filter(bomb -> bomb.m_19749_() == owner);
    }

    public static void handleHurtEvent(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Entity entity2 = event.getSource().m_7639_();
            if (entity2 instanceof LivingEntity) {
                List<SolarisBomb> candids;
                LivingEntity owner = (LivingEntity)entity2;
                if (!event.getSource().m_269533_(DamageTypeTags.f_273918_) && !(candids = SolarisBomb.getAllBombsOwnedBy(owner, level2).toList()).isEmpty()) {
                    SolarisBomb bomb = candids.get(entity.m_217043_().m_188503_(candids.size()));
                    bomb.setLooseTarget(entity);
                    bomb.m_20256_(entity.m_20182_().m_82546_(bomb.m_20182_()).m_82490_(0.1));
                }
            }
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.explodeFire();
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            LivingEntity target;
            Player player = (Player)entity;
            Entity entity2 = pResult.m_82443_();
            if (entity2 instanceof LivingEntity && (target = (LivingEntity)entity2) != this.m_19749_()) {
                this.initiateAbilityAttack((LivingEntity)player, target, 5.0f, AttackHurtTypes.RAPID);
                target.m_20254_(4);
                if (target == this.getLooseTarget()) {
                    this.explodeFire();
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.explodeFire();
    }

    public void explodeFire() {
        this.m_5496_(SoundEvents.f_12062_, 1.0f, 1.0f);
        for (int i = 0; i < 90; ++i) {
            double xx = this.f_19796_.m_188583_() * 0.05;
            double yy = this.f_19796_.m_188583_() * 0.05;
            double zz = this.f_19796_.m_188583_() * 0.05;
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), xx, yy, zz);
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), xx / 2.0, yy / 2.0, zz / 2.0);
        }
        for (LivingEntity targets : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(1.6, 1.6, 1.6))) {
            Entity entity = this.m_19749_();
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            this.initiateAbilityAttack((LivingEntity)player, targets, 2.0f, AttackHurtTypes.RAPID_NO_KB);
            targets.m_20254_(2);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_20068_() {
        return true;
    }

    @Nullable
    public LivingEntity getLooseTarget() {
        int data = (Integer)this.f_19804_.m_135370_(LOOSE_TARGET);
        if (data == 0) {
            return null;
        }
        Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(LOOSE_TARGET)).intValue());
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            return living;
        }
        return null;
    }

    public void setLooseTarget(LivingEntity target) {
        this.f_19804_.m_135381_(LOOSE_TARGET, (Object)target.m_19879_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LOOSE_TARGET, (Object)0);
    }
}

