/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.compat.bettercombat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public abstract class BCDatagenUtil
implements DataProvider {
    public final Map<String, Pair<RegistryObject<? extends ItemLike>, AttributesContainer>> data = new TreeMap<String, Pair<RegistryObject<? extends ItemLike>, AttributesContainer>>();
    public final PackOutput output;
    public final String modid;

    public BCDatagenUtil(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    public void addAttribute(RegistryObject<? extends ItemLike> item, AttributesContainer attribute) {
        this.data.put(item.getId().m_135815_(), (Pair<RegistryObject<? extends ItemLike>, AttributesContainer>)Pair.of(item, (Object)attribute));
    }

    protected abstract void registerAttributes();

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        this.registerAttributes();
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Pair<RegistryObject<? extends ItemLike>, AttributesContainer> pairs : this.data.values()) {
            futures[i++] = this.save(pOutput, (RegistryObject<? extends ItemLike>)((RegistryObject)pairs.getFirst()), (AttributesContainer)pairs.getSecond());
        }
        return CompletableFuture.allOf(futures);
    }

    protected CompletableFuture<?> save(CachedOutput pOutput, RegistryObject<? extends ItemLike> item, AttributesContainer attribute) {
        Path target = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("weapon_attributes").resolve(item.getId().m_135815_() + ".json");
        return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)this.compileAttributeJson(attribute), (Path)target);
    }

    protected JsonObject compileAttributeJson(AttributesContainer attribute) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", attribute.parent());
        if (attribute.attributes() != null) {
            JsonObject attributes = new JsonObject();
            if (attribute.attributes().attackRange() != 0.0) {
                attributes.addProperty("attack_range", (Number)attribute.attributes().attackRange());
            }
            if (attribute.attributes().pose() != null) {
                attributes.addProperty("pose", attribute.attributes().pose());
            }
            if (attribute.attributes().offHandPose() != null) {
                attributes.addProperty("off_hand_pose", attribute.attributes().offHandPose());
            }
            if (attribute.attributes().two_handed() != null) {
                attributes.addProperty("two_handed", attribute.attributes().two_handed());
            }
            if (attribute.attributes().category() != null) {
                attributes.addProperty("category", attribute.attributes().category());
            }
            if (attribute.attributes().attacks() != null) {
                JsonArray attacksArray = new JsonArray();
                for (WeaponAttributes.Attack attack : attribute.attributes().attacks()) {
                    attacksArray.add((JsonElement)BCDatagenUtil.createAttackJsonArray(attack));
                }
                attributes.add("attacks", (JsonElement)attacksArray);
            }
            json.add("attributes", (JsonElement)attributes);
        }
        return json;
    }

    private static JsonObject createAttackJsonArray(WeaponAttributes.Attack attack) {
        JsonObject json = new JsonObject();
        JsonArray conditionsArray = new JsonArray();
        if (attack.conditions() != null) {
            for (WeaponAttributes.Condition condition : attack.conditions()) {
                conditionsArray.add(condition.name());
            }
            json.add("conditions", (JsonElement)conditionsArray);
        }
        if (attack.hitbox() != null) {
            json.addProperty("hitbox", attack.hitbox().name());
        }
        if (attack.damageMultiplier() != 1.0) {
            json.addProperty("damage_multiplier", (Number)attack.damageMultiplier());
        }
        if (attack.damageMultiplier() != 0.0) {
            json.addProperty("angle", (Number)attack.angle());
        }
        if (attack.damageMultiplier() != 0.0) {
            json.addProperty("upswing", (Number)attack.upswing());
        }
        if (attack.animation() != null) {
            json.addProperty("animation", attack.animation());
        }
        if (attack.swingSound() != null) {
            JsonObject swingSound = new JsonObject();
            swingSound.addProperty("id", attack.swingSound().id());
            swingSound.addProperty("volume", (Number)Float.valueOf(attack.swingSound().volume()));
            swingSound.addProperty("pitch", (Number)Float.valueOf(attack.swingSound().pitch()));
            swingSound.addProperty("randomness", (Number)Float.valueOf(attack.swingSound().randomness()));
            json.add("swing_sound", (JsonElement)swingSound);
        }
        JsonObject impactSound = new JsonObject();
        if (attack.impactSound() != null) {
            impactSound.addProperty("id", attack.impactSound().id());
            impactSound.addProperty("volume", (Number)Float.valueOf(attack.impactSound().volume()));
            impactSound.addProperty("pitch", (Number)Float.valueOf(attack.impactSound().pitch()));
            impactSound.addProperty("randomness", (Number)Float.valueOf(attack.impactSound().randomness()));
            json.add("impact_sound", (JsonElement)impactSound);
        }
        return json;
    }

    public String m_6055_() {
        return StringUtils.capitalize((String)this.modid) + ": Better Combat Compatibility";
    }
}

