/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.client.gui.starlitfactory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.thecelestialworkshop.celestisynth.Celestisynth;
import org.thecelestialworkshop.celestisynth.client.gui.starlitfactory.StarlitFactoryMenu;
import org.thecelestialworkshop.celestisynth.common.registry.CSBlocks;
import software.bernie.geckolib.core.object.Color;

public class StarlitFactoryScreen
extends AbstractContainerScreen<StarlitFactoryMenu> {
    public static final ResourceLocation FACTORY_GUI = Celestisynth.prefix("textures/gui/starlit_factory.png");
    private final ArrayList<FactoryStar> stars = new ArrayList();
    private int usedProTip;

    public StarlitFactoryScreen(StarlitFactoryMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.usedProTip = Minecraft.m_91087_().f_91074_.m_217043_().m_188503_(5);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        if (Minecraft.m_91087_().f_91074_.f_19797_ % 200 == 0) {
            this.usedProTip = this.usedProTip >= 4 ? 0 : this.usedProTip + 1;
        }
        MutableComponent text = Component.m_237115_((String)("tip.celestisynth.starlit_factory_" + this.usedProTip));
        int i = 0;
        for (FormattedCharSequence formattedcharsequence : this.f_96547_.m_92923_((FormattedText)text, 180)) {
            pGuiGraphics.m_280364_(this.f_96547_, formattedcharsequence, this.f_97735_ + 89, this.f_97736_ + 170 + i * 9, Color.WHITE.argbInt());
            ++i;
        }
        pGuiGraphics.m_280168_().m_85836_();
        double xOff = (double)this.f_96543_ / 2.0;
        double yOff = (double)this.f_96544_ / 2.0;
        pGuiGraphics.m_280168_().m_85837_(xOff, yOff, 0.0);
        assert (Minecraft.m_91087_().f_91074_ != null);
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)((float)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.015)))));
        pGuiGraphics.m_280168_().m_85837_(-xOff, -yOff, 0.0);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        assert (this.f_96541_.f_91073_ != null);
        RandomSource random = this.f_96541_.f_91073_.f_46441_;
        if (random.m_188503_(10) == 0) {
            int offset = random.m_188503_(pGuiGraphics.m_280182_());
            this.stars.add(new FactoryStar(-50 + offset, -20, 0.5 + random.m_188500_(), 0.5 + random.m_188500_()));
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    public void m_280273_(GuiGraphics pGuiGraphics) {
        int factoryForgeTime = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(2);
        if (factoryForgeTime > 0) {
            float motion = Mth.m_14031_((float)((float)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.2)));
            Color color = Color.ofRGBA((float)0.0f, (float)0.0f, (float)(0.1f + motion * 0.1f), (float)0.75f);
            pGuiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, color.argbInt(), color.darker(15.0f).argbInt());
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundRendered((Screen)this, pGuiGraphics));
        } else {
            super.m_280273_(pGuiGraphics);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        float motion = Mth.m_14031_((float)((float)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.2))) * 1.0f;
        Color color = Color.ofRGBA((float)(0.75f + motion * 0.25f), (float)(0.75f + motion * 0.25f), (float)1.0f, (float)1.0f);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)CSBlocks.STARLIT_FACTORY.get()), this.f_97728_ - 5, this.f_97729_ - 22);
        this.f_96547_.m_168645_(this.f_96539_.m_7532_(), (float)(this.f_97728_ + 15), (float)(this.f_97729_ - 15), color.argbInt(), color.darker(5.0f).getColor(), pGuiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        float motion = Mth.m_14031_((float)((float)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.05))) * 1.0f;
        float motion2 = Mth.m_14089_((float)((float)((double)Minecraft.m_91087_().f_91074_.f_19797_ * 0.05))) * 1.0f;
        for (FactoryStar star : this.stars) {
            if (star.tickCount >= 1000) continue;
            star.render(pGuiGraphics);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)(0.95f + motion * 0.05f), (float)(0.95f + motion2 * 0.05f), (float)1.0f, (float)1.0f);
        pGuiGraphics.m_280218_(FACTORY_GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int energyBurnTime = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(0);
        int energyAmount = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(1);
        int factoryForgeTime = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(2);
        int maxFactoryForgeTime = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(3);
        boolean isHoldingValidRecipe = ((StarlitFactoryMenu)this.f_97732_).data.m_6413_(4) == 1;
        double burnProgress = (double)energyBurnTime / 100.0;
        pGuiGraphics.m_280218_(FACTORY_GUI, this.f_97735_ + 135, this.f_97736_ + 30, 193, 16, (int)(burnProgress * 14.0), 2);
        double energyAmountProgress = (double)energyAmount / 1000.0;
        int vOffset = (int)(52.0 - energyAmountProgress * 52.0);
        pGuiGraphics.m_280218_(FACTORY_GUI, this.f_97735_ + 152, this.f_97736_ + 17 + vOffset, 176, vOffset, 16, (int)(energyAmountProgress * 52.0));
        double forgeProgress = (double)factoryForgeTime / (double)maxFactoryForgeTime;
        pGuiGraphics.m_280218_(FACTORY_GUI, this.f_97735_ + 62, this.f_97736_ + 3, 208, 0, 44, (int)(forgeProgress * 75.0));
        if (isHoldingValidRecipe) {
            pGuiGraphics.m_280218_(FACTORY_GUI, this.f_97735_ + 26, this.f_97736_ + 34, 192, 0, 16, 15);
        }
    }

    public static class FactoryStar {
        private final int centerX;
        private final int centerY;
        private final double speedX;
        private final double speedY;
        public float scale;
        public int tickCount;
        public boolean isReverse;

        public FactoryStar(int centerX, int centerY, double speedX, double speedY) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.speedX = speedX;
            this.speedY = speedY;
            this.scale = 1.0f + Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 0.5f;
            this.isReverse = Minecraft.m_91087_().f_91074_.m_217043_().m_188499_();
        }

        public void render(GuiGraphics pGuiGraphics) {
            ++this.tickCount;
            assert (Minecraft.m_91087_().f_91074_ != null);
            RenderSystem.enableBlend();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.5f + Mth.m_14031_((float)((float)this.tickCount * 0.02f)) + 0.5f);
            pGuiGraphics.m_280168_().m_85836_();
            double xOff = (double)this.centerX + (double)this.tickCount * this.speedX;
            double yOff = (double)this.centerY + (double)this.tickCount * this.speedY;
            pGuiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)this.tickCount * (this.isReverse ? -0.2f : 0.2f)));
            pGuiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
            pGuiGraphics.m_280218_(FACTORY_GUI, (int)xOff, (int)yOff, 192, 32, 16, 16);
            pGuiGraphics.m_280168_().m_85849_();
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
    }
}

