/*
 * Decompiled with CFR 0.152.
 */
package com.overcontrol1.mcreatormemfix;

import com.overcontrol1.mcreatormemfix.ModConfig;
import com.overcontrol1.mcreatormemfix.ModConfigEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.service.MixinService;

@Mod(value="mcreator_mem_fix")
public class MCreatorMemFix {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MCreatorMemFix");
    public static final String MOD_ID = "mcreator_mem_fix";

    public MCreatorMemFix(FMLJavaModLoadingContext ctx) {
        ctx.getModEventBus().addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        if (ModConfig.REGENERATION_LOCKED) {
            ModConfig.REQUIRES_REGENERATION = false;
            return;
        }
        ModConfig config = ModConfig.instance();
        if (config.spec() != 0) {
            ModConfig.REQUIRES_REGENERATION = true;
        }
        long modHash = MCreatorMemFix.hashMods();
        if (config.hash() != modHash) {
            ModConfig.REQUIRES_REGENERATION = true;
        }
        if (ModConfig.REQUIRES_REGENERATION) {
            List<ModConfigEntry> entries = MCreatorMemFix.findEntries();
            ModConfig newConfig = new ModConfig(entries, 0, modHash);
            newConfig.save();
            LOGGER.warn("[MCreatorMemFix] Scanned {} MCreator mods in this environment. RESTART RECOMMENDED.", (Object)entries.size());
        }
    }

    private static List<ModConfigEntry> findEntries() {
        ArrayList<ModConfigEntry> entries = new ArrayList<ModConfigEntry>();
        ModList.get().forEachModContainer((id, container) -> {
            Object mod = container.getMod();
            Class<?> clazz = mod.getClass();
            String simpleName = clazz.getSimpleName();
            String packageName = clazz.getPackageName();
            String variableClassName = packageName + ".network." + simpleName + "Variables$PlayerVariables";
            try {
                MixinService.getService().getBytecodeProvider().getClassNode(variableClassName);
                String simpleNameWithoutMod = simpleName.substring(0, simpleName.length() - 3);
                entries.add(new ModConfigEntry(packageName, simpleNameWithoutMod));
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        });
        return entries;
    }

    private static long hashMods() {
        long result = 17L;
        for (IModInfo info : ModList.get().getMods()) {
            result = 37L * result + (long)info.getModId().hashCode();
        }
        return result;
    }
}

