/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import tomson124.simplyjetpacks.item.JetpackItem;
import tomson124.simplyjetpacks.util.JetpackUtil;

public class PacketUpdateThrottle {
    private final int throttleValue;

    public PacketUpdateThrottle(int throttleValue) {
        this.throttleValue = throttleValue;
    }

    public static PacketUpdateThrottle fromBytes(FriendlyByteBuf buffer) {
        return new PacketUpdateThrottle(buffer.readInt());
    }

    public static void toBytes(PacketUpdateThrottle message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.throttleValue);
    }

    public static void handle(PacketUpdateThrottle message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            Item item;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (item = (stack = JetpackUtil.getFromBothSlots((Player)player)).m_41720_()) instanceof JetpackItem) {
                JetpackItem jetpack = (JetpackItem)item;
                jetpack.setThrottle(stack, message.throttleValue);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

