/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.item;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import tomson124.simplyjetpacks.SimplyJetpacks;
import tomson124.simplyjetpacks.datagen.SJDamageTypes;
import tomson124.simplyjetpacks.handlers.CommonJetpackHandler;
import tomson124.simplyjetpacks.handlers.RegistryHandler;
import tomson124.simplyjetpacks.item.JetpackArmorMaterial;
import tomson124.simplyjetpacks.item.JetpackItem;
import tomson124.simplyjetpacks.item.JetpackType;
import tomson124.simplyjetpacks.util.JetpackUtil;
import tomson124.simplyjetpacks.util.KeyboardUtil;
import tomson124.simplyjetpacks.util.NBTUtil;
import tomson124.simplyjetpacks.util.SJTextUtil;

public class PotatoJetpackItem
extends JetpackItem {
    public PotatoJetpackItem() {
        super(JetpackType.POTATO, JetpackArmorMaterial.POTATO);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(IClientItemExtensions.DEFAULT);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ForgeCapabilities.ENERGY == null) {
            return;
        }
        tooltip.add(SJTextUtil.translate("tooltip", "jetpack_potato", new Object[0]));
        SJTextUtil.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            tooltip.add(SJTextUtil.translate("tooltip", "jetpack_potato.warning", ChatFormatting.RED, new Object[0]));
        } else {
            tooltip.add(SJTextUtil.getShiftText());
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!player.m_5833_() && stack == JetpackUtil.getFromBothSlots(player)) {
            this.flyUser(player, stack, this, true);
            if (this.getJetpackType().getChargerMode() && this.isChargerOn(stack)) {
                super.chargeInventory(player, stack);
            }
        }
    }

    @Override
    public void flyUser(Player player, ItemStack stack, JetpackItem item, Boolean force) {
        if (super.isEngineOn(stack)) {
            if (this.isFired(stack)) {
                super.flyUser(player, stack, item, true);
                player.f_20885_ += 37.5f;
                if (item.getEnergy(stack) <= 0) {
                    Random random = new Random();
                    player.m_150109_().m_36057_(stack);
                    if (!player.m_20193_().m_5776_()) {
                        player.m_20193_().m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    }
                    for (int i = 0; i <= random.nextInt(3) + 4; ++i) {
                        SimplyJetpacks.LOGGER.info("SJ2: CREATING FIREWORKS!");
                    }
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42674_), false);
                    player.m_6469_(SJDamageTypes.provideDamage(player.m_20193_(), random.nextBoolean() ? SJDamageTypes.DEATH_BY_POTATO_JETPACK : SJDamageTypes.DEATH_BY_JETPACK_EXPLOSION), 100.0f);
                }
            } else if (force.booleanValue() || CommonJetpackHandler.isHoldingUp(player)) {
                if (this.isTimerSet(stack)) {
                    this.decrementTimer(stack, player);
                } else {
                    this.setTimer(stack, 50);
                }
            }
        }
    }

    public boolean isFired(ItemStack itemStack) {
        return NBTUtil.getBoolean(itemStack, "Fired");
    }

    private void setFired(ItemStack itemStack) {
        NBTUtil.setBoolean(itemStack, "Fired", true);
    }

    private boolean isTimerSet(ItemStack itemStack) {
        return NBTUtil.getBoolean(itemStack, "RocketTimerSet");
    }

    private void setTimer(ItemStack itemStack, int timer) {
        NBTUtil.setInt(itemStack, "RocketTimer", timer);
        NBTUtil.setBoolean(itemStack, "RocketTimerSet", true);
    }

    private void decrementTimer(ItemStack itemStack, Player player) {
        int timer = NBTUtil.getInt(itemStack, "RocketTimer");
        timer = timer > 0 ? timer - 1 : 0;
        NBTUtil.setInt(itemStack, "RocketTimer", timer);
        if (timer == 0) {
            this.setFired(itemStack);
            player.m_20193_().m_6269_(player, (Entity)player, (SoundEvent)RegistryHandler.ROCKET_SOUND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

