/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.hud;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import tomson124.simplyjetpacks.SimplyJetpacks;
import tomson124.simplyjetpacks.config.ConfigDefaults;
import tomson124.simplyjetpacks.config.SimplyJetpacksConfig;

public class HUDRenderHelper {
    private static final Font font = Minecraft.m_91087_().f_91062_;

    public static void drawStringAtPosition(GuiGraphics graphics, Window window, Component text, int lineOffset) {
        int windowScaleHeight = window.m_85446_();
        int windowScaleWidth = window.m_85445_();
        ConfigDefaults.HUDPosition position = (ConfigDefaults.HUDPosition)((Object)SimplyJetpacksConfig.hudTextPosition.get());
        int color = (Integer)SimplyJetpacksConfig.hudTextColor.get();
        int xOffset = (Integer)SimplyJetpacksConfig.hudXOffset.get();
        int yOffset = (Integer)SimplyJetpacksConfig.hudYOffset.get();
        long hudScale = (Long)SimplyJetpacksConfig.hudScale.get();
        boolean hudTextShadow = (Boolean)SimplyJetpacksConfig.hudTextShadow.get();
        int screenHeight = (int)((long)windowScaleHeight / hudScale);
        int screenWidth = (int)((long)windowScaleWidth / hudScale);
        switch (position) {
            case TOP_LEFT: {
                HUDRenderHelper.drawStringLeft(graphics, text, 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_CENTER: {
                HUDRenderHelper.drawStringCenter(graphics, text, screenWidth / 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case TOP_RIGHT: {
                HUDRenderHelper.drawStringRight(graphics, text, screenWidth - 2 + xOffset, 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case LEFT: {
                HUDRenderHelper.drawStringLeft(graphics, text, 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case RIGHT: {
                HUDRenderHelper.drawStringRight(graphics, text, screenWidth - 2 + xOffset, screenHeight / 2 + (yOffset += lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_LEFT: {
                HUDRenderHelper.drawStringLeft(graphics, text, 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            case BOTTOM_RIGHT: {
                HUDRenderHelper.drawStringRight(graphics, text, screenWidth - 2 + xOffset, screenHeight - 9 + (yOffset -= lineOffset * 9), color, hudTextShadow);
                break;
            }
            default: {
                SimplyJetpacks.LOGGER.info("Invalid HUD Position passed to renderer.");
            }
        }
    }

    private static void drawStringLeft(GuiGraphics graphics, Component text, int x, int y, int color, boolean shadow) {
        graphics.m_280614_(font, text, x, y, color, shadow);
    }

    private static void drawStringCenter(GuiGraphics graphics, Component text, int x, int y, int color, boolean shadow) {
        float textWidth = font.m_92852_((FormattedText)text);
        graphics.m_280614_(font, text, (int)((float)x - textWidth / 2.0f), y, color, shadow);
    }

    private static void drawStringRight(GuiGraphics graphics, Component text, int x, int y, int color, boolean shadow) {
        float textWidth = font.m_92852_((FormattedText)text);
        graphics.m_280614_(font, text, (int)((float)x - textWidth), y, color, shadow);
    }
}

