/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.handlers;

import java.time.LocalDate;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tomson124.simplyjetpacks.SimplyJetpacks;
import tomson124.simplyjetpacks.config.SimplyJetpacksConfig;
import tomson124.simplyjetpacks.handlers.CommonJetpackHandler;
import tomson124.simplyjetpacks.item.JetpackItem;
import tomson124.simplyjetpacks.item.JetpackType;
import tomson124.simplyjetpacks.item.PotatoJetpackItem;
import tomson124.simplyjetpacks.particle.JetpackParticleType;
import tomson124.simplyjetpacks.sound.JetpackSound;
import tomson124.simplyjetpacks.util.JetpackUtil;
import tomson124.simplyjetpacks.util.Pos3D;

@OnlyIn(value=Dist.CLIENT)
public class ClientJetpackHandler {
    @SubscribeEvent
    public void onClientPlayerQuit(ClientPlayerNetworkEvent.LoggingOut loggedOutEvent) {
        SimplyJetpacks.LOGGER.info("Reverting jetpack settings to client config.");
        JetpackType.loadAllConfigs();
        SimplyJetpacks.LOGGER.info("Client jetpack config successfully reverted.");
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!(event.phase != TickEvent.Phase.END || minecraft.f_91074_ == null || minecraft.f_91073_ == null || minecraft.m_91104_() || minecraft.f_91074_.m_5833_() || minecraft.f_91074_.m_150110_().f_35935_)) {
            ItemStack chest = JetpackUtil.getFromBothSlots((Player)minecraft.f_91074_);
            Item item = chest.m_41720_();
            if (!chest.m_41619_() && item instanceof JetpackItem && ClientJetpackHandler.isFlying((Player)minecraft.f_91074_) || item instanceof PotatoJetpackItem && ((PotatoJetpackItem)item).isFired(chest)) {
                JetpackParticleType particleType;
                if (((Boolean)SimplyJetpacksConfig.enableJetpackParticles.get()).booleanValue() && minecraft.f_91066_.m_231929_().m_231551_() != ParticleStatus.MINIMAL && (particleType = minecraft.f_91074_.m_20071_() ? JetpackParticleType.BUBBLES : (ClientJetpackHandler.checkValentines() ? JetpackParticleType.HEARTS : JetpackParticleType.values()[JetpackItem.getParticleId(chest)])).getParticleData() != null) {
                    this.showJetpackParticles(minecraft, particleType);
                }
                if (((Boolean)SimplyJetpacksConfig.enableJetpackSounds.get()).booleanValue() && !JetpackSound.playing(minecraft.f_91074_.m_19879_())) {
                    minecraft.m_91106_().m_120367_((SoundInstance)new JetpackSound((Player)minecraft.f_91074_));
                }
            }
        }
    }

    private void showJetpackParticles(Minecraft minecraft, JetpackParticleType particleType) {
        double[] dArray;
        ParticleOptions particle = particleType.getParticleData();
        Random rand = new Random();
        float random = (rand.nextFloat() - 0.5f) * 0.1f;
        if (minecraft.f_91074_.m_6047_()) {
            double[] dArray2 = new double[2];
            dArray2[0] = -0.3;
            dArray = dArray2;
            dArray2[1] = -0.1;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        }
        double[] sneakBonus = dArray;
        Pos3D playerPos = new Pos3D((Entity)minecraft.f_91074_).translate(0.0, 1.5, 0.0);
        Pos3D vLeft = new Pos3D(-0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.f_91074_.f_20883_, 0.0f);
        Pos3D vRight = new Pos3D(0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.f_91074_.f_20883_, 0.0f);
        Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.f_91074_.f_20883_, 0.0f);
        Pos3D v = playerPos.translate((Vec3)vLeft).translate((Vec3)new Pos3D(minecraft.f_91074_.m_20184_()));
        minecraft.f_91061_.m_107370_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
        v = playerPos.translate((Vec3)vRight).translate((Vec3)new Pos3D(minecraft.f_91074_.m_20184_()));
        minecraft.f_91061_.m_107370_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
        if (particleType != JetpackParticleType.HEARTS) {
            v = playerPos.translate((Vec3)vCenter).translate((Vec3)new Pos3D(minecraft.f_91074_.m_20184_()));
            minecraft.f_91061_.m_107370_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
        }
    }

    public static boolean isFlying(Player player) {
        JetpackItem jetpack;
        Item item;
        ItemStack stack = JetpackUtil.getFromBothSlots(player);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof JetpackItem && (jetpack = (JetpackItem)item).isEngineOn(stack) && (jetpack.getEnergy(stack) > 0 || jetpack.isCreative())) {
            if (jetpack.isHoverOn(stack)) {
                return !player.m_20096_();
            }
            return CommonJetpackHandler.isHoldingUp(player);
        }
        return false;
    }

    private static boolean checkValentines() {
        LocalDate today = LocalDate.now();
        int day = today.getDayOfMonth();
        int month = today.getMonthValue();
        return day == 14 && month == 2;
    }
}

