/*
 * Decompiled with CFR 0.152.
 */
package tomson124.simplyjetpacks.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomShapedRecipeBuilder
extends ShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    public CustomShapedRecipeBuilder(ItemLike result, int count) {
        super(RecipeCategory.MISC, result, count);
        this.result = result.m_5456_();
        this.count = count;
    }

    public CustomShapedRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    private boolean hasCriteria() {
        return !this.advancement.m_138405_().isEmpty();
    }

    public static CustomShapedRecipeBuilder shaped(ItemLike item) {
        return CustomShapedRecipeBuilder.shaped(item, 1);
    }

    public static CustomShapedRecipeBuilder shaped(ItemLike item, int count) {
        return new CustomShapedRecipeBuilder(item, count);
    }

    public CustomShapedRecipeBuilder define(Character character, TagKey<Item> item) {
        return this.define(character, Ingredient.m_204132_(item));
    }

    public CustomShapedRecipeBuilder define(Character character, ItemLike item) {
        return this.define(character, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public CustomShapedRecipeBuilder define(Character character, Ingredient item) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, item);
        return this;
    }

    public CustomShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public CustomShapedRecipeBuilder unlockedBy(String name, Criterion criteria) {
        this.advancement.m_138383_(name, criteria);
        return this;
    }

    public CustomShapedRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void m_176498_(Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.result));
    }

    public void m_176500_(Consumer<FinishedRecipe> consumer, String id) {
        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.result);
        if (new ResourceLocation(id).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Shaped Recipe " + id + " should remove its 'save' argument");
        }
        this.m_126140_(consumer, new ResourceLocation(id));
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        if (this.hasCriteria()) {
            this.advancement.m_138396_(new ResourceLocation("simplyjetpacks", "root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        consumer.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.rows, this.key, this.advancement));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;

        public Result(ResourceLocation id, Item result, @Nullable int count, String group, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
        }

        public void m_7917_(JsonObject jsonObject) {
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            jsonObject.add("pattern", (JsonElement)patternArray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            jsonObject.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject2.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject2);
        }

        public JsonObject m_125966_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", BuiltInRegistries.f_256769_.m_7981_(this.m_6637_()).toString());
            JsonArray conditionsArray = new JsonArray();
            if (!CustomShapedRecipeBuilder.this.conditions.isEmpty()) {
                for (ICondition condition : CustomShapedRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return CustomShapedRecipeBuilder.this.hasCriteria() ? this.advancement.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return new ResourceLocation("simplyjetpacks", (this.group != null ? this.group : "") + this.id.m_135815_());
        }
    }
}

