/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.showcaseitem.message;

import com.ultramega.showcaseitem.message.IMessage;
import com.ultramega.showcaseitem.message.MessageSerializer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    public final SimpleChannel channel;
    private int i = 0;

    public NetworkHandler(String modid, int protocol) {
        this(modid, "main", protocol);
    }

    public NetworkHandler(String modid, String channelName, int protocol) {
        String protocolStr = Integer.toString(protocol);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, channelName)).networkProtocolVersion(() -> protocolStr).clientAcceptedVersions(protocolStr::equals).serverAcceptedVersions(protocolStr::equals).simpleChannel();
    }

    public <T extends IMessage> void register(Class<T> clazz, NetworkDirection dir) {
        BiConsumer<IMessage, FriendlyByteBuf> encoder = MessageSerializer::writeObject;
        Function<FriendlyByteBuf, IMessage> decoder = buf -> {
            try {
                IMessage msg = (IMessage)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MessageSerializer.readObject(msg, buf);
                return msg;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
        BiConsumer<IMessage, Supplier> consumer = (msg, supp) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supp.get();
            if (context.getDirection() != dir) {
                return;
            }
            context.setPacketHandled(msg.receive(context));
        };
        this.channel.registerMessage(this.i, clazz, encoder, decoder, consumer);
        ++this.i;
    }

    public void sendToServer(IMessage msg) {
        this.channel.sendToServer((Object)msg);
    }
}

