/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ProgramShortcutButton;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerOpenProgram;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Desktop {
    private static final int SHORTCUT_AREA_WIDTH = 220;
    private static final int SHORTCUT_COLUMNS = 7;
    private final ComputerScreen screen;
    private final List<ProgramShortcutButton> shortcuts;
    private int displayStart;
    private int displayTop;
    private int displayWidth;
    private int displayHeight;

    public Desktop(ComputerScreen screen) {
        this.screen = screen;
        this.shortcuts = this.createProgramShortcuts();
    }

    private List<ProgramShortcutButton> createProgramShortcuts() {
        int index = 0;
        ArrayList<ProgramShortcutButton> shortcuts = new ArrayList<ProgramShortcutButton>();
        for (ResourceLocation id : Computer.get().getPrograms()) {
            Icon icon = Display.get().getIcon(id);
            if (icon == null) continue;
            shortcuts.add(new ProgramShortcutButton(this.screen, index++, 42, 32, this.getProgramName(id), icon, btn -> {
                Network.getPlay().sendToServer((IMessage)new MessageComputerOpenProgram(id));
                btn.m_93692_(false);
            }));
        }
        return shortcuts;
    }

    public void update(int displayStart, int displayTop, int displayWidth, int displayHeight) {
        this.displayStart = displayStart;
        this.displayTop = displayTop;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        int startX = displayStart + (displayWidth - 220) / 2;
        int startY = displayTop + 4;
        this.shortcuts.forEach(shortcut -> {
            int shortcutX = startX + shortcut.getIndex() % 7 * 42 + shortcut.getIndex() % 7 * 4;
            int shortcutY = startY + shortcut.getIndex() / 7 * 32 + shortcut.getIndex() / 7 * 4;
            shortcut.m_264152_(shortcutX, shortcutY);
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(this.displayStart, this.displayTop, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -14277082);
        this.shortcuts.forEach(shortcut -> shortcut.m_88315_(graphics, mouseX, mouseY, partialTick));
        graphics.m_280509_(this.displayStart, this.displayTop + this.displayHeight - 16, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -10857649);
        graphics.m_280509_(this.displayStart, this.displayTop + this.displayHeight - 16 + 2, this.displayStart + this.displayWidth, this.displayTop + this.displayHeight, -13423059);
        Font font = Minecraft.m_91087_().f_91062_;
        String timeLabel = this.getDayTimeLabel();
        int width = font.m_92895_(timeLabel);
        graphics.m_280056_(font, timeLabel, this.displayStart + this.displayWidth - width - 5, this.displayTop + this.displayHeight - 11, -1, false);
        graphics.m_280411_(ComputerScreen.TEXTURE, this.displayStart, this.displayTop + this.displayHeight - 24, 32, 36, 0.0f, 150.0f, 16, 18, 256, 256);
    }

    private Component getProgramName(ResourceLocation id) {
        return Component.m_237115_((String)String.format("computer_program.%s.%s", id.m_135827_(), id.m_135815_()));
    }

    public List<ProgramShortcutButton> getShortcuts() {
        return this.shortcuts;
    }

    private String getDayTimeLabel() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            long time = (level.m_46468_() + 6000L) % 24000L;
            long hours = time / 1000L;
            long minutes = 60L * (time % 1000L) / 1000L;
            return "%d:%02d".formatted(hours, minutes);
        }
        return "";
    }
}

