/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.KitchenSinkBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class KitchenSinkBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public KitchenSinkBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.KITCHEN_SINK.get(), pos, state);
    }

    public KitchenSinkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.kitchenSink.fluidCapacity.get(), container -> {
            this.m_6596_();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        if (this.interactWithBottle(player, hand, this.f_58858_).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.performPlatformInteraction(player, hand, this.f_58858_, result.m_82434_()).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.kitchenSink.dispenseWater.get()).booleanValue() && result.m_82434_() != Direction.DOWN) {
            if (this.tryAndFillWithFluid(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82512_((Vec3i)this.f_58858_)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryAndCreateObsidian(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82539_((Vec3i)this.f_58858_).m_82520_(0.0, 1.0, 0.0)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void playWaterAnimation() {
        this.animationTime = 4;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, KitchenSinkBlockEntity kitchenSink) {
        if (kitchenSink.animationTime > 0) {
            Vec3 tap = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.m_231075_((Direction)state.m_61143_((Property)KitchenSinkBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.f_82479_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                double z = tap.f_82481_ + Utils.pixels(0.5) * level.f_46441_.m_188583_();
                level.m_7106_((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.f_82480_, z, 0.0, 0.0, 0.0);
            }
            --kitchenSink.animationTime;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.load(tag.m_128469_("FluidTank"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag);
        tag.m_128365_("FluidTank", (Tag)tankTag);
    }
}

