/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;

public class PhasedFieldGenerator
extends Item
implements IEnergyItem,
ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"power", this::getEnergyString)});

    private String getEnergyString(ItemStack stack) {
        return Integer.toString(stack.m_41782_() ? stack.m_41783_().m_128451_("Energy") : 0);
    }

    public PhasedFieldGenerator() {
        super(RFToolsDim.setup.defaultProperties().m_41487_(1));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41619_() != newStack.m_41619_()) {
            return true;
        }
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, list, flagIn);
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        CompoundTag tag = container.m_41784_();
        long energy = tag.m_128454_("Energy");
        long energyReceived = Math.min(this.getMaxEnergyStoredL(container) - energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_RECEIVEPERTICK.get(), maxReceive));
        if (!simulate) {
            tag.m_128356_("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        CompoundTag tag = container.m_41784_();
        long energy = tag.m_128454_("Energy");
        long energyExtracted = Math.min(energy, Math.min((Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get() * 10L, maxExtract));
        if (!simulate) {
            tag.m_128356_("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0L;
        }
        return container.m_41783_().m_128454_("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return (Long)DimensionBuilderConfig.PHASEDFIELD_MAXENERGY.get();
    }

    public static boolean checkValidPhasedFieldGenerator(Player player, boolean consume, int tickCost) {
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            int toConsume;
            PhasedFieldGenerator pfg;
            int energyStored;
            ItemStack slot = inventory.m_8020_(i);
            if (slot.m_41619_() || slot.m_41720_() != DimensionBuilderModule.PHASED_FIELD_GENERATOR.get() || (energyStored = (pfg = (PhasedFieldGenerator)slot.m_41720_()).getEnergyStored(slot)) < (toConsume = (Boolean)DimensionConfig.ENABLE_DYNAMIC_PHASECOST.get() != false ? (int)((double)(10 * tickCost) * (Double)DimensionConfig.DYNAMIC_PHASECOST_AMOUNT.get()) : (int)(10L * (Long)DimensionBuilderConfig.PHASEDFIELD_CONSUMEPERTICK.get()))) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }
}

