/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class TagBlastingRecipe
extends BlastingRecipe {
    protected final Ingredient resultIngredient;

    public TagBlastingRecipe(ResourceLocation idIn, CookingBookCategory category, String groupIn, Ingredient ingredientIn, Ingredient resultIn, float experienceIn, int cookTimeIn) {
        super(idIn, groupIn, category, ingredientIn, new ItemStack((ItemLike)Items.f_42749_), experienceIn, cookTimeIn);
        this.resultIngredient = resultIn;
    }

    public Ingredient getIngredient() {
        return this.f_43729_;
    }

    public Ingredient getResultIngredient() {
        return this.resultIngredient;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.resultIngredient.m_43908_()[0];
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)OreBerryRecipes.TAG_BLASTING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<TagBlastingRecipe> {
        public TagBlastingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CookingBookCategory cookingbookcategory = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CookingBookCategory.MISC);
            Object jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            jsonelement = GsonHelper.m_13885_((JsonObject)json, (String)"result") ? GsonHelper.m_13933_((JsonObject)json, (String)"result") : GsonHelper.m_13930_((JsonObject)json, (String)"result");
            Ingredient result = Ingredient.m_43917_((JsonElement)jsonelement);
            if (result.m_43947_()) {
                throw new JsonSyntaxException("Missing result: ingredient has no matching stacks");
            }
            float f = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int i = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)100);
            return new TagBlastingRecipe(recipeId, cookingbookcategory, s, ingredient, result, f, i);
        }

        @Nullable
        public TagBlastingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            CookingBookCategory cookingbookcategory = (CookingBookCategory)buffer.m_130066_(CookingBookCategory.class);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient result = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            float f = buffer.readFloat();
            int i = buffer.m_130242_();
            return new TagBlastingRecipe(recipeId, cookingbookcategory, s, ingredient, result, f, i);
        }

        public void toNetwork(FriendlyByteBuf buffer, TagBlastingRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245534_());
            recipe.getIngredient().m_43923_(buffer);
            recipe.getResultIngredient().m_43923_(buffer);
            buffer.writeFloat(recipe.m_43750_());
            buffer.m_130130_(recipe.m_43753_());
        }
    }
}

