/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.block;

import com.mrbysco.oreberriesreplanted.block.OreEnum;
import com.mrbysco.oreberriesreplanted.config.OreBerriesConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class OreBerryBushBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<Item> berryItem;
    private final OreEnum oreType;

    public OreBerryBushBlock(BlockBehaviour.Properties properties, Supplier<Item> berryItem, OreEnum oreType) {
        super(properties.m_60977_().m_60978_(0.3f).m_60918_(SoundType.f_56743_).m_60955_().m_60960_(OreBerryBushBlock::isntSolid).m_60971_(OreBerryBushBlock::isntSolid));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.berryItem = berryItem;
        this.oreType = oreType;
    }

    public int getDensity() {
        return this.oreType.getDensity();
    }

    protected ItemLike getBerryItem() {
        return (ItemLike)this.berryItem.get();
    }

    public static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource rand) {
        if (!serverLevel.f_46443_ && !this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)pos, (BlockState)state, (rand.m_188503_(((Integer)OreBerriesConfig.COMMON.growthChance.get()).intValue()) == 0 ? 1 : 0) != 0)) {
            boolean flag;
            boolean bl = flag = !this.oreType.getDarknessOnly() || serverLevel.m_45524_(pos, 0) < 10;
            if (flag) {
                int currentAge = this.getAge(state);
                serverLevel.m_7731_(pos, this.withAge(currentAge + 1), 3);
                ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)serverLevel.m_8055_(pos));
            }
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.harvestBerry(state, level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.harvestBerry(state, level, pos);
    }

    public InteractionResult harvestBerry(BlockState state, Level level, BlockPos pos) {
        if (this.isMaxAge(state)) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            level.m_7731_(pos, this.withAge(this.getMaxAge() - 1), 3);
            OreBerryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(this.getBerryItem(), level.f_46441_.m_188503_(3) + 1));
        }
        return InteractionResult.PASS;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (state.m_60734_() == this) {
            return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= 2;
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        boolean flag = !this.oreType.getDarknessOnly() || level.m_45524_(pos, 0) < 13;
        return flag && blockstate.canSustainPlant((BlockGetter)level, blockpos, Direction.UP, (IPlantable)this);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof ItemEntity)) {
            entityIn.m_6469_(level.m_269111_().m_269325_(), 1.0f);
        }
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CAVE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

