/*
 * Decompiled with CFR 0.152.
 */
package waves.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.ClientEventHandler;
import waves.client.ClientHelpers;
import waves.common.entities.Wave;
import waves.util.RenderHelpers;

public class WaveRenderer
extends EntityRenderer<Wave> {
    public final BufferBuilder builder = Tesselator.m_85913_().m_85915_();

    public WaveRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114476_.m_114473_(false);
        this.f_114476_.m_114468_(false);
    }

    public void render(Wave wave, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        int i;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        ResourceLocation texture = wave.getWaveTexture();
        this.builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        RenderSystem.setShader(GameRenderer::m_172835_);
        RenderHelpers.translucentTransparency();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.m_85836_();
        Vector3f[] quad = (Vector3f[])Arrays.stream(ClientHelpers.QUAD).map(Vector3f::new).toArray(Vector3f[]::new);
        for (i = 0; i < 4; ++i) {
            Vector3f vector3 = quad[i];
            vector3.rotate((Quaternionfc)wave.getRotation());
            vector3.mul(wave.getQuadSize());
        }
        for (i = 0; i < 4; ++i) {
            RenderHelpers.drawVertex((VertexConsumer)this.builder, poseStack, matrix, quad[i], wave.getColor(), ClientHelpers.UVS[i], wave.getPackedLight());
        }
        poseStack.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)this.builder.m_231175_());
    }

    public boolean shouldRender(Wave wave, Frustum frustum, double camX, double camY, double camZ) {
        if (ClientEventHandler.player != null) {
            Vec3 pos = wave.getPos();
            Vec3 posOld = wave.getPosOld();
            float partialTicks = ClientEventHandler.partialTicks;
            double x = Mth.m_14139_((double)partialTicks, (double)posOld.m_7096_(), (double)pos.m_7096_());
            double y = Mth.m_14139_((double)partialTicks, (double)posOld.m_7098_(), (double)pos.m_7098_());
            double z = Mth.m_14139_((double)partialTicks, (double)posOld.m_7094_(), (double)pos.m_7094_());
            double distanceToParticle = ClientEventHandler.player.m_20182_().m_82554_(wave.m_20182_());
            return (ClientHelpers.isInFrustum(new Vec3(x, y, z)) || distanceToParticle <= 20.0) && distanceToParticle <= (double)ClientHelpers.getChunkRenderDistance() * 16.0;
        }
        return false;
    }

    public ResourceLocation getTextureLocation(Wave wave) {
        return wave.getWaveTexture();
    }
}

