/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.platform;

import com.illusivesoulworks.consecration.ConsecrationConstants;
import com.illusivesoulworks.consecration.platform.services.ICapabilityService;
import com.illusivesoulworks.consecration.platform.services.INetworkService;
import com.illusivesoulworks.consecration.platform.services.IPlatformService;
import com.illusivesoulworks.consecration.platform.services.IRegistryService;
import java.util.ServiceLoader;

public class Services {
    public static final IRegistryService REGISTRY = Services.load(IRegistryService.class);
    public static final IPlatformService PLATFORM = Services.load(IPlatformService.class);
    public static final INetworkService NETWORK = Services.load(INetworkService.class);
    public static final ICapabilityService CAPABILITY = Services.load(ICapabilityService.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        ConsecrationConstants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

