/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.effect;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.mixin.AccessorZombieVillager;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;

public class HolyEffect
extends MobEffect {
    public HolyEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, @Nonnull LivingEntity livingEntity, int amplifier, double health) {
        if (livingEntity instanceof ZombieVillager) {
            this.convertZombieVillager((ZombieVillager)livingEntity, indirectSource, 1800 >> amplifier);
        } else {
            Optional<? extends IUndying> maybeUndying = ConsecrationApi.getInstance().getUndying(livingEntity);
            maybeUndying.ifPresentOrElse(undying -> {
                if (source == null) {
                    livingEntity.m_6469_(ConsecrationApi.getInstance().causeHolyDamage(livingEntity.m_9236_().m_9598_()), (float)(8 << amplifier));
                } else {
                    livingEntity.m_6469_(ConsecrationApi.getInstance().causeIndirectHolyDamage(source, indirectSource), (float)(8 << amplifier));
                }
            }, () -> {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, amplifier));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, amplifier));
            });
        }
    }

    public boolean m_8093_() {
        return true;
    }

    private void convertZombieVillager(ZombieVillager zombieVillager, @Nullable Entity source, int conversionTime) {
        if (zombieVillager.m_34408_()) {
            return;
        }
        UUID uuid = source instanceof Player ? source.m_20148_() : null;
        ((AccessorZombieVillager)zombieVillager).callStartConverting(uuid, conversionTime);
    }
}

