/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.capability;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.common.ConsecrationEvents;
import com.illusivesoulworks.consecration.common.impl.Undying;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UndyingCapability {
    public static final Capability<IUndying> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IUndying>(){});
    public static final ResourceLocation ID = new ResourceLocation("consecration", "undying");

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            evt.addCapability(ID, (ICapabilityProvider)new Provider(livingEntity));
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingTickEvent evt) {
        ConsecrationApi.getInstance().getUndying(evt.getEntity()).ifPresent(IUndying::tick);
    }

    @SubscribeEvent
    public void potionAdded(MobEffectEvent.Added evt) {
        ConsecrationApi.getInstance().getUndying(evt.getEntity()).ifPresent(undying -> undying.onEffectAdded(evt.getEffectInstance()));
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(IUndying::sync);
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent evt) {
        evt.setAmount(ConsecrationEvents.onDamaged(evt.getEntity(), evt.getSource(), evt.getAmount()));
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        final LazyOptional<IUndying> optional;
        final IUndying data;

        Provider(LivingEntity livingEntity) {
            this.data = new Undying(livingEntity);
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == INSTANCE ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.data.writeTag();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.data.readTag(tag);
        }
    }
}

